/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search.timing;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.qfm.erp.service.model.search.timing.ETimingCategory;
import de.qfm.erp.service.model.search.timing.TimingEntry;
import de.qfm.erp.service.model.search.timing.TimingResult;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public class Timing {
    private final Stopwatch stopwatch;
    private final List<Pair<ETimingCategory, Long>> timingBuilder = Lists.newArrayList();

    private Timing(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
    }

    @Nonnull
    public static Timing createStarted() {
        return new Timing(Stopwatch.createStarted());
    }

    @Nonnull
    public Timing finishQueryAnalysis() {
        return this.track(ETimingCategory.QUERY_ANALYSIS);
    }

    @Nonnull
    public Timing finishQueryGeneration() {
        return this.track(ETimingCategory.QUERY_GENERATION);
    }

    @Nonnull
    public Timing finishQueryIndex(@NonNull TimingResult timingResult) {
        if (timingResult == null) {
            throw new NullPointerException("timingResult is marked non-null but is null");
        }
        this.inject(timingResult);
        return this.track(ETimingCategory.QUERY_INDEX);
    }

    @Nonnull
    public Timing finishIndexPrepare() {
        return this.track(ETimingCategory.INDEX_PREPARE);
    }

    @Nonnull
    public Timing finishIndexSearch() {
        return this.track(ETimingCategory.INDEX_SEARCH);
    }

    @Nonnull
    public Timing finishIndexDocumentFetch() {
        return this.track(ETimingCategory.INDEX_DOCUMENT_FETCH);
    }

    @Nonnull
    public Timing finishIndexFacetFetch() {
        return this.track(ETimingCategory.INDEX_FACET_FETCH);
    }

    @Nonnull
    public Timing finishHighLight() {
        return this.track(ETimingCategory.HIGHLIGHT);
    }

    @Nonnull
    public Timing finishSpellCheck() {
        return this.track(ETimingCategory.SPELLCHECK);
    }

    @Nonnull
    public Timing finishAlternative() {
        return this.track(ETimingCategory.ALTERNATIVE);
    }

    private Long elapsed() {
        return this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
    }

    @Nonnull
    public TimingResult build() {
        long overallDuration = this.elapsed();
        ImmutableList.Builder timingEntryBuilder = ImmutableList.builder();
        long previous = 0L;
        for (Pair pair : this.timingBuilder) {
            ETimingCategory key = (ETimingCategory)pair.getKey();
            Long value = (Long)pair.getValue();
            long duration = value - previous;
            previous = value;
            timingEntryBuilder.add((Object)TimingEntry.of((ETimingCategory)key, (long)value, (long)duration));
        }
        ImmutableList timingEntries = timingEntryBuilder.build();
        return TimingResult.of((long)overallDuration, (Iterable)timingEntries);
    }

    @Nonnull
    Timing inject(@NonNull TimingResult timingResult) {
        if (timingResult == null) {
            throw new NullPointerException("timingResult is marked non-null but is null");
        }
        Pair last = (Pair)Iterables.getLast((Iterable)this.timingBuilder);
        long offset = null != last ? (Long)last.getValue() : 0L;
        timingResult.getEntries().forEach(timingEntry -> {
            ETimingCategory category = timingEntry.getCategory();
            long timing = timingEntry.getTiming();
            long localTiming = timing + offset;
            this.timingBuilder.add(Pair.of((Object)category, (Object)localTiming));
        });
        return this;
    }

    @Nonnull
    private Timing track(@NonNull ETimingCategory category) {
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        this.timingBuilder.add(Pair.of((Object)category, (Object)this.elapsed()));
        return this;
    }
}

