/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.search.IndexResultItem;
import lombok.NonNull;

public class IndexResult {
    public static IndexResult EMPTY = new IndexResult(IndexResultItem.EMPTY, (Iterable)ImmutableList.of());
    @NonNull
    private final IndexResultItem root;
    @NonNull
    private final Iterable<IndexResultItem> children;

    private IndexResult(@NonNull IndexResultItem root, @NonNull Iterable<IndexResultItem> children) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        this.root = root;
        this.children = children;
    }

    public static IndexResult of(@NonNull IndexResultItem root, @NonNull Iterable<IndexResultItem> children) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        return new IndexResult(root, children);
    }

    @NonNull
    public IndexResultItem getRoot() {
        return this.root;
    }

    @NonNull
    public Iterable<IndexResultItem> getChildren() {
        return this.children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexResult)) {
            return false;
        }
        IndexResult other = (IndexResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IndexResultItem this$root = this.getRoot();
        IndexResultItem other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        Iterable this$children = this.getChildren();
        Iterable other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !this$children.equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IndexResultItem $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        Iterable $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : $children.hashCode());
        return result;
    }

    public String toString() {
        return "IndexResult(root=" + String.valueOf(this.getRoot()) + ", children=" + String.valueOf(this.getChildren()) + ")";
    }
}

