/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.search.IndexField;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EMeasurementIndexField implements IndexField
{
    UNKNOWN("unknown"),
    _ID("_id"),
    _SOURCE("_source"),
    _TYPE("_type"),
    _ALL("_all"),
    ENTRY_TYPE("entry_type"),
    MEASUREMENT__ENTITY_STATE("measurement.entity_state"),
    MEASUREMENT__CREATED_ON("measurement.created_on"),
    MEASUREMENT__CREATED_BY("measurement.created_by"),
    MEASUREMENT__UPDATED_ON("measurement.updated_on"),
    MEASUREMENT__UPDATED_BY("measurement.updated_by"),
    MEASUREMENT__MEASUREMENT_NUMBER("measurement.measurement_number"),
    MEASUREMENT__ORIGINAL_MEASUREMENT_NUMBER("measurement.original_measurement_number"),
    MEASUREMENT__ASSIGNED_USER_NAME("measurement.assigned_user_name"),
    MEASUREMENT__ASSIGNED_USER_FULL_NAME("measurement.assigned_user_full_name"),
    MEASUREMENT__MEASUREMENT_STATE("measurement.measurement_state"),
    MEASUREMENT__MEASUREMENT_TYPE("measurement.measurement_type"),
    MEASUREMENT__MEASUREMENT_VIEW_TYPE("measurement.measurement_view_type"),
    MEASUREMENT__INVOICE_NUMBER("measurement.invoice_number"),
    MEASUREMENT__CONSTRUCTION_SITE("measurement.construction_site"),
    MEASUREMENT__CUSTOMER_AREA("measurement.customer_area"),
    MEASUREMENT__RELEASE_ORDER__NAME("measurement.release_order.name"),
    MEASUREMENT__RELEASE_ORDER__ORDER_NUMBER("measurement.release_order.order_number"),
    MEASUREMENT__PSS_RELEASE_ORDER__EXTERNAL_ID("measurement.pss_release_order.external_id"),
    MEASUREMENT__PSS_RELEASE_ORDER__NAME("measurement.pss_release_order.name"),
    MEASUREMENT__QUOTATION_NUMBER("measurement.stage.quotation_number"),
    MEASUREMENT__STAGE_NUMBER("measurement.stage.stage_number"),
    MEASUREMENT__STAGE_ALIAS("measurement.stage.stage_alias"),
    MEASUREMENT__ENTITY_NUMBER("measurement.stage.entity_number"),
    MEASUREMENT__ENTITY_ALIAS("measurement.stage.entity_alias"),
    MEASUREMENT__CUSTOMER__NAME("measurement.customer.name"),
    MEASUREMENT__CUSTOMER__DEBTOR_ACCOUNT_NUMBER("measurement.customer.debtor_account_number"),
    SORT_MEASUREMENT__CREATED_ON("sort.measurement.created_on"),
    SORT_MEASUREMENT__UPDATED_ON("sort.measurement.updated_on"),
    SPELLCHECK__CLAZZ("spellcheck_clazz"),
    SPELLCHECK__FIELD("spellcheck_field"),
    SPELLCHECK__VALUE("spellcheck_value"),
    SPELLCHECK__PHONETIC("spellcheck_phonetic"),
    SPELLCHECK__LENGTH("spellcheck_length");

    private final String fieldName;
    private static final Map<String, EMeasurementIndexField> LOOKUP;
    @Nonnull
    public static final Iterable<IndexField> STRING_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<EMeasurementIndexField> MEASUREMENT__FULLTEXT_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> NUMERIC_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> ALL_NO_ANALYZER_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> CATCH_ALL_FIELDS;

    private EMeasurementIndexField(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.fieldName = fieldName;
    }

    @Nonnull
    public static Iterable<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EMeasurementIndexField lookup(@NonNull String candidate, @NonNull EMeasurementIndexField defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EMeasurementIndexField.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EMeasurementIndexField> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EMeasurementIndexField.key((String)candidate);
        return Optional.ofNullable((EMeasurementIndexField)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EMeasurementIndexField hint) {
        if (hint == null) {
            throw new NullPointerException("hint is marked non-null but is null");
        }
        return EMeasurementIndexField.key((String)hint.fieldName());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String fieldName() {
        return this.fieldName;
    }

    @Nonnull
    public Iterable<IndexField> numericFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public Iterable<IndexField> copyFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public String messageCode() {
        return "index_field." + this.fieldName;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EMeasurementIndexField value : EMeasurementIndexField.values()) {
            String key = EMeasurementIndexField.key((EMeasurementIndexField)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        STRING_QUERY_FIELDS = ImmutableSet.of((Object)MEASUREMENT__ASSIGNED_USER_NAME, (Object)MEASUREMENT__ASSIGNED_USER_FULL_NAME, (Object)MEASUREMENT__MEASUREMENT_TYPE, (Object)MEASUREMENT__MEASUREMENT_VIEW_TYPE, (Object)MEASUREMENT__INVOICE_NUMBER, (Object)MEASUREMENT__CONSTRUCTION_SITE, (Object[])new IndexField[]{MEASUREMENT__CUSTOMER_AREA, MEASUREMENT__CUSTOMER__NAME, MEASUREMENT__RELEASE_ORDER__NAME, MEASUREMENT__RELEASE_ORDER__ORDER_NUMBER, MEASUREMENT__STAGE_NUMBER, MEASUREMENT__ENTITY_NUMBER, MEASUREMENT__QUOTATION_NUMBER});
        MEASUREMENT__FULLTEXT_QUERY_FIELDS = ImmutableSet.of((Object)MEASUREMENT__STAGE_NUMBER, (Object)MEASUREMENT__ENTITY_NUMBER, (Object)MEASUREMENT__QUOTATION_NUMBER, (Object)MEASUREMENT__MEASUREMENT_NUMBER, (Object)MEASUREMENT__ORIGINAL_MEASUREMENT_NUMBER, (Object)MEASUREMENT__INVOICE_NUMBER, (Object[])new EMeasurementIndexField[]{MEASUREMENT__RELEASE_ORDER__NAME, MEASUREMENT__PSS_RELEASE_ORDER__NAME, MEASUREMENT__CONSTRUCTION_SITE, MEASUREMENT__ASSIGNED_USER_FULL_NAME, MEASUREMENT__CUSTOMER__NAME, MEASUREMENT__CUSTOMER__DEBTOR_ACCOUNT_NUMBER});
        NUMERIC_FIELDS = ImmutableSet.of((Object)MEASUREMENT__MEASUREMENT_NUMBER, (Object)MEASUREMENT__RELEASE_ORDER__ORDER_NUMBER, (Object)MEASUREMENT__PSS_RELEASE_ORDER__EXTERNAL_ID);
        ALL_NO_ANALYZER_FIELDS = ImmutableSet.of((Object)MEASUREMENT__QUOTATION_NUMBER, (Object)MEASUREMENT__INVOICE_NUMBER, (Object)MEASUREMENT__STAGE_NUMBER, (Object)MEASUREMENT__ENTITY_NUMBER, (Object)MEASUREMENT__CUSTOMER__DEBTOR_ACCOUNT_NUMBER);
        CATCH_ALL_FIELDS = ImmutableSet.builder().addAll(STRING_QUERY_FIELDS).addAll(NUMERIC_FIELDS).build();
    }
}

