/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.search.IndexField;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EEntityIndexField implements IndexField
{
    _ID("_id"),
    _SOURCE("_source"),
    _TYPE("_type"),
    _ALL("_all"),
    ENTRY_TYPE("entry_type"),
    ENTITY__ENTITY_STATE("entity.entity_state"),
    ENTITY__QENTITY_STATE("entity.q_entity_state"),
    ENTITY__CREATED_ON("entity.created_on"),
    ENTITY__CREATED_BY("entity.created_by"),
    ENTITY__UPDATED_ON("entity.updated_on"),
    ENTITY__UPDATED_BY("entity.updated_by"),
    ENTITY__ENTITY_NUMBER("entity.entity_number"),
    ENTITY__ENTITY_ALIAS("entity.entity_alias"),
    ENTITY__PRIMARY_STAGE_NUMBER("entity.primary_stage.stage_number"),
    ENTITY__PRIMARY_STAGE_QUOTATION_NUMBER("entity.primary_stage.quotation_number"),
    ENTITY__PRIMARY_STAGE_ALIAS("entity.primary_stage.alias"),
    ENTITY__PRIMARY_STAGE_TYPE("entity.primary_stage.stage_type"),
    ENTITY__PRIMARY_STAGE_STATE("entity.primary_stage.stage_state"),
    ENTITY__CUSTOMER__ID("entity.customer.id"),
    ENTITY__CUSTOMER__NAME("entity.customer.name"),
    SORT_ENTITY__CREATED_ON("sort.entity.created_on"),
    SORT_ENTITY__UPDATED_ON("sort.entity.updated_on"),
    SPELLCHECK__CLAZZ("spellcheck_clazz"),
    SPELLCHECK__FIELD("spellcheck_field"),
    SPELLCHECK__VALUE("spellcheck_value"),
    SPELLCHECK__PHONETIC("spellcheck_phonetic"),
    SPELLCHECK__LENGTH("spellcheck_length");

    private final String fieldName;
    private static final Map<String, EEntityIndexField> LOOKUP;
    @Nonnull
    public static final Iterable<IndexField> STRING_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<EEntityIndexField> ENTITY__FULLTEXT_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> ALL_NO_ANALYZER_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> NUMERIC_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> CATCH_ALL_FIELDS;

    private EEntityIndexField(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.fieldName = fieldName;
    }

    @Nonnull
    public static Iterable<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EEntityIndexField lookup(@NonNull String candidate, @NonNull EEntityIndexField defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EEntityIndexField.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EEntityIndexField> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EEntityIndexField.key((String)candidate);
        return Optional.ofNullable((EEntityIndexField)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EEntityIndexField hint) {
        if (hint == null) {
            throw new NullPointerException("hint is marked non-null but is null");
        }
        return EEntityIndexField.key((String)hint.fieldName());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String fieldName() {
        return this.fieldName;
    }

    @Nonnull
    public Iterable<IndexField> numericFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public Iterable<IndexField> copyFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public String messageCode() {
        return "index_field." + this.fieldName;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EEntityIndexField value : EEntityIndexField.values()) {
            String key = EEntityIndexField.key((EEntityIndexField)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        STRING_QUERY_FIELDS = ImmutableSet.of((Object)ENTITY__ENTITY_NUMBER, (Object)ENTITY__ENTITY_ALIAS, (Object)ENTITY__PRIMARY_STAGE_NUMBER, (Object)ENTITY__PRIMARY_STAGE_ALIAS, (Object)ENTITY__CUSTOMER__NAME);
        ENTITY__FULLTEXT_QUERY_FIELDS = ImmutableSet.of((Object)ENTITY__ENTITY_NUMBER, (Object)ENTITY__ENTITY_ALIAS, (Object)ENTITY__PRIMARY_STAGE_NUMBER, (Object)ENTITY__PRIMARY_STAGE_ALIAS, (Object)ENTITY__CUSTOMER__NAME);
        ALL_NO_ANALYZER_FIELDS = ImmutableSet.of((Object)ENTITY__PRIMARY_STAGE_QUOTATION_NUMBER, (Object)ENTITY__ENTITY_NUMBER, (Object)ENTITY__PRIMARY_STAGE_NUMBER);
        NUMERIC_FIELDS = ImmutableSet.of();
        CATCH_ALL_FIELDS = ImmutableSet.builder().addAll(STRING_QUERY_FIELDS).addAll(NUMERIC_FIELDS).build();
    }
}

