/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.shared;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EPositionType {
    UNKNOWN,
    STANDARD,
    GROUP,
    CHILD,
    COMMENT,
    REMARK,
    CHANGE_IN_QUANTITY,
    CORRECTION,
    JUMBO,
    JUMBO_INTERNAL_TYPE_A,
    JUMBO_INTERNAL_TYPE_B,
    JUMBO_INTERNAL_TYPE_C,
    DELETED;

    private static final Map<String, EPositionType> LOOKUP;
    public static final Iterable<EPositionType> WAGE_AND_VALUE_TYPES;
    public static final Iterable<EPositionType> GROUPING_POSITION_TYPES;
    public static final Iterable<EPositionType> PRINTABLE_POSITIONS;
    public static final Iterable<EPositionType> GROUPING_CHILDREN_POSITION_TYPES;
    public static final Iterable<EPositionType> PRINT_FORMAT_BOLD_DEFAULT;
    public static final Iterable<EPositionType> JUMBO_ANY;
    public static final Iterable<EPositionType> JUMBO_CHILD;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EPositionType lookup(@NonNull String candidate, @NonNull EPositionType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EPositionType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EPositionType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EPositionType.key((String)candidate);
        return Optional.ofNullable((EPositionType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EPositionType EPositionType2) {
        if (EPositionType2 == null) {
            throw new NullPointerException("EPositionType is marked non-null but is null");
        }
        return EPositionType.key((String)EPositionType2.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EPositionType value : EPositionType.values()) {
            String key = EPositionType.key((EPositionType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        WAGE_AND_VALUE_TYPES = ImmutableSet.of((Object)STANDARD, (Object)CHANGE_IN_QUANTITY, (Object)JUMBO, (Object)JUMBO_INTERNAL_TYPE_A, (Object)JUMBO_INTERNAL_TYPE_B);
        GROUPING_POSITION_TYPES = ImmutableSet.of((Object)STANDARD, (Object)CHANGE_IN_QUANTITY, (Object)JUMBO);
        PRINTABLE_POSITIONS = ImmutableSet.of((Object)STANDARD, (Object)CHANGE_IN_QUANTITY, (Object)REMARK, (Object)JUMBO, (Object)JUMBO_INTERNAL_TYPE_A, (Object)JUMBO_INTERNAL_TYPE_B, (Object[])new EPositionType[0]);
        GROUPING_CHILDREN_POSITION_TYPES = ImmutableSet.of((Object)STANDARD, (Object)CHANGE_IN_QUANTITY, (Object)REMARK, (Object)JUMBO);
        PRINT_FORMAT_BOLD_DEFAULT = ImmutableSet.of((Object)REMARK, (Object)COMMENT, (Object)GROUP);
        JUMBO_ANY = ImmutableSet.of((Object)JUMBO, (Object)JUMBO_INTERNAL_TYPE_A, (Object)JUMBO_INTERNAL_TYPE_B, (Object)JUMBO_INTERNAL_TYPE_C);
        JUMBO_CHILD = ImmutableSet.of((Object)JUMBO_INTERNAL_TYPE_A, (Object)JUMBO_INTERNAL_TYPE_B, (Object)JUMBO_INTERNAL_TYPE_C);
    }
}

