/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.quotation;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EQStageNumberType implements Translatable
{
    UNKNOWN,
    INQUIRY,
    CALCULATION,
    QUOTATION,
    COMMISSION,
    ADDENDUM,
    COST_UNIT;

    private static final Map<String, EQStageNumberType> LOOKUP;
    public static final Map<EQStageType, EQStageNumberType> TYPE_MAPPING;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EQStageNumberType lookup(@NonNull String candidate, @NonNull EQStageNumberType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EQStageNumberType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EQStageNumberType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EQStageNumberType.key((String)candidate);
        return Optional.ofNullable((EQStageNumberType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EQStageNumberType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EQStageNumberType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.stage_number_type." + StringUtils.lowerCase((String)this.name());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EQStageNumberType value : EQStageNumberType.values()) {
            String key = EQStageNumberType.key((EQStageNumberType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        TYPE_MAPPING = ImmutableMap.builder().put((Object)EQStageType.INQUIRY, (Object)INQUIRY).put((Object)EQStageType.CALCULATION, (Object)CALCULATION).put((Object)EQStageType.QUOTATION, (Object)QUOTATION).put((Object)EQStageType.COMMISSION, (Object)COMMISSION).put((Object)EQStageType.COMMISSION__ADDENDUM, (Object)ADDENDUM).put((Object)EQStageType.COST_UNIT__ADDENDUM, (Object)ADDENDUM).put((Object)EQStageType.COMMISSION__COST_UNIT, (Object)COST_UNIT).put((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object)COST_UNIT).put((Object)EQStageType.COMMISSION__COST_ESTIMATE, (Object)COST_UNIT).build();
    }
}

