/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.quotation;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ECommissionType {
    UNKNOWN,
    FRAMEWORK_CONTRACT,
    ORDER,
    INTERNAL,
    SUBCONTRACTOR,
    RELEASE_ORDER_CONTRACT;

    private static final Map<String, ECommissionType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static ECommissionType lookup(@NonNull String candidate, @NonNull ECommissionType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return ECommissionType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<ECommissionType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = ECommissionType.key((String)candidate);
        return Optional.ofNullable((ECommissionType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull ECommissionType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return ECommissionType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ECommissionType value : ECommissionType.values()) {
            String key = ECommissionType.key((ECommissionType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

