/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.measurement.type;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EMeasurementViewType implements Translatable
{
    STANDARD("standard"),
    TRANSPOSED("transposed");

    private final String value;
    private static final Map<String, EMeasurementViewType> LOOKUP;

    private EMeasurementViewType(String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EMeasurementViewType lookup(@NonNull String candidate, @NonNull EMeasurementViewType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EMeasurementViewType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EMeasurementViewType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EMeasurementViewType.key((String)candidate);
        return Optional.ofNullable((EMeasurementViewType)LOOKUP.get(key));
    }

    @NonNull
    public static EMeasurementViewType lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional measurementViewTypeCandidate = EMeasurementViewType.lookup((String)candidate);
        if (measurementViewTypeCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_VIEW_TYPE), (String)candidate, EMeasurementViewType.class, EMeasurementViewType::allowedKeys);
        }
        return (EMeasurementViewType)measurementViewTypeCandidate.get();
    }

    @Nonnull
    private static String key(@NonNull EMeasurementViewType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EMeasurementViewType.key((String)item.getValue());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.measurement_view_type." + this.value;
    }

    public String getValue() {
        return this.value;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EMeasurementViewType value : EMeasurementViewType.values()) {
            String key = EMeasurementViewType.key((EMeasurementViewType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

