/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.measurement;

import de.qfm.erp.service.helper.NullIntegerConverter;
import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.User;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="MeasurementPosition")
@Table(name="MEASUREMENT_POSITION")
public class MeasurementPosition
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MEASUREMENT_POSITION_SEQ")
    @SequenceGenerator(sequenceName="MEASUREMENT_POSITION_SEQ", allocationSize=1, name="MEASUREMENT_POSITION_SEQ")
    private Long id;
    @Column(name="reference_id", length=75)
    private String referenceId;
    @JoinColumn(name="measurement_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Measurement measurement;
    @JoinColumn(name="quotation_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Quotation quotation;
    @JoinColumn(name="quotation_position_id")
    @ManyToOne(fetch=FetchType.EAGER)
    private QuotationPosition quotationPosition;
    @JoinColumn(name="jumbo_quotation_position_id")
    @ManyToOne(fetch=FetchType.EAGER)
    private QuotationPosition jumboQuotationPosition;
    @JoinColumn(name="invoice_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Invoice invoice;
    @JoinColumn(name="assigned_user_id")
    @ManyToOne
    private User assignedUser;
    @Convert(converter=NullStringConverter.class)
    @Column(name="surrogate_position_number", length=75)
    private String surrogatePositionNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="jumbo_position_spn", length=75)
    private String jumboPositionSurrogatePositionNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="quotation_position_number", length=20)
    private String quotationPositionNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="position_number_external", length=75)
    private String positionNumberExternal;
    @Column(name="quotation_sub_position_number", length=2)
    private Integer quotationSubPositionNumber;
    @Column(name="accounting_month")
    private LocalDate accountingMonth;
    @Column(name="addendum_number")
    private Long addendumNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="group_level_1", length=9)
    private String groupingElementLevel1;
    @Convert(converter=NullStringConverter.class)
    @Column(name="group_level_2", length=9)
    private String groupingElementLevel2;
    @Convert(converter=NullStringConverter.class)
    @Column(name="group_level_3", length=9)
    private String groupingElementLevel3;
    @Convert(converter=NullStringConverter.class)
    @Column(name="group_level_4", length=9)
    private String groupingElementLevel4;
    @Convert(converter=NullStringConverter.class)
    @Column(name="flag_alternative_position")
    private String flagAlternativePosition;
    @Enumerated(value=EnumType.STRING)
    @Column(name="alternative_position_type", length=50)
    private EAlternativePositionType alternativePositionType;
    @Column(name="flag_flat_rate")
    private Boolean flagFlatRate;
    @Column(name="flag_cancel")
    private Boolean flagCancel;
    @Column(name="flag_not_in_quotation")
    private Boolean flagNotInQuotation;
    @Convert(converter=NullIntegerConverter.class)
    @Column(name="seq_number_invoice")
    private Integer sequenceNumberInvoice;
    @Convert(converter=NullIntegerConverter.class)
    @Column(name="seq_number_measure_standard")
    private Integer sequenceNumberMeasurementStandard;
    @Convert(converter=NullIntegerConverter.class)
    @Column(name="seq_number_measure_transposed")
    private Integer sequenceNumberMeasurementTransposed;
    @Convert(converter=NullIntegerConverter.class)
    @Column(name="column_index_transposed")
    private Integer columnIndexTransposed;
    @Column(name="amount")
    private BigDecimal amount;
    @Column(name="factor_1")
    private BigDecimal factor1;
    @Column(name="factor_2")
    private BigDecimal factor2;
    @Column(name="factor_3")
    private BigDecimal factor3;
    @Column(name="product")
    private BigDecimal product;
    @Convert(converter=NullStringConverter.class)
    @Lob
    @Column(name="remarks", length=3000)
    private String remarks;
    @Convert(converter=NullStringConverter.class)
    @Column(name="unit", length=40)
    private String unit;
    @Convert(converter=NullStringConverter.class)
    @Column(name="jumbo_position_unit", length=40)
    private String jumboPositionUnit;
    @Column(name="unit_amount")
    private BigDecimal unitAmount;
    @Convert(converter=NullStringConverter.class)
    @Column(name="short_text", length=500)
    private String shortText;
    @Convert(converter=NullStringConverter.class)
    @Column(name="jumbo_position_short_text", length=500)
    private String jumboPositionShortText;
    @Convert(converter=NullStringConverter.class)
    @Lob
    @Column(name="long_text", length=100000)
    private String longText;
    @Column(name="internal_wage_per_unit")
    private BigDecimal internalWagePerUnit;
    @Column(name="internal_wage_agg")
    private BigDecimal internalWageAggregated;
    @Column(name="mat_selling_price_per_unit")
    private BigDecimal materialSellingPricePerUnit;
    @Column(name="mat_selling_price_agg")
    private BigDecimal materialSellingPriceAggregated;
    @Column(name="mat_purchase_exc_disc_agg")
    private BigDecimal materialPurchasePriceExcludingDiscountAggregated;
    @Column(name="mat_purchase_inc_disc_agg")
    private BigDecimal materialPurchasePriceIncludingDiscountAggregated;
    @Column(name="mat_purchase_discount")
    private BigDecimal materialPurchasePriceDiscount;
    @Column(name="mat_purchase_exc_disc_per_unit")
    private BigDecimal materialPurchasePriceExcludingDiscountPerUnit;
    @Column(name="mat_purchase_inc_disc_per_unit")
    private BigDecimal materialPurchasePriceIncludingDiscountPerUnit;
    @Column(name="company_wage_per_unit")
    private BigDecimal companyWagePerUnit;
    @Column(name="company_wage_agg")
    private BigDecimal companyWageAggregated;
    @Deprecated
    @Column(name="company_wage_agg_discount")
    private BigDecimal companyWageAggregatedDiscount;
    @Deprecated
    @Column(name="mat_selling_price_agg_discount")
    private BigDecimal materialSellingPriceAggregatedDiscount;
    @Deprecated
    @Column(name="price_agg_discount")
    private BigDecimal priceAggregatedDiscount;
    @Deprecated
    @Column(name="discount")
    private BigDecimal discount;
    @Deprecated
    @Column(name="other_discount")
    private BigDecimal otherDiscount;
    @Column(name="internal_squad_wage_per_unit")
    private BigDecimal internalSquadWagePerUnit;
    @Column(name="internal_squad_wage_agg")
    private BigDecimal internalSquadWageAggregated;
    @Convert(converter=NullStringConverter.class)
    @Column(name="article_code", length=15)
    private String articleCode;
    @Convert(converter=NullStringConverter.class)
    @Column(name="article_name", length=120)
    private String articleName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="supplier_code", length=5)
    private String supplierCode;
    @Column(name="price_per_unit")
    private BigDecimal pricePerUnit;
    @Column(name="jumbo_position_price_per_unit")
    private BigDecimal jumboPositionPricePerUnit;
    @Column(name="price_aggregated")
    private BigDecimal priceAggregated;
    @Enumerated(value=EnumType.STRING)
    @Column(name="position_type", length=50)
    private EPositionType positionType;
    @Column(name="material_percentage")
    private BigDecimal materialPercentage;
    @Column(name="wage_percentage")
    private BigDecimal wagePercentage;
    @Column(name="overall_percentage")
    private BigDecimal aggregatedPercentage;
    @Column(name="es_purchase_price_per_unit")
    private BigDecimal externalServicePurchasePricePerUnit;
    @Column(name="es_purchase_price_aggregated")
    private BigDecimal externalServicePurchasePriceAggregated;
    @Column(name="es_percentage")
    private BigDecimal externalServicePercentage;
    @Column(name="es_selling_price_per_unit")
    private BigDecimal externalServiceSellingPricePerUnit;
    @Column(name="es_selling_price_aggregated")
    private BigDecimal externalServiceSellingPriceAggregated;
    @Column(name="flag_fee_position")
    private Boolean flagFeePosition;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        MeasurementPosition that = (MeasurementPosition)o;
        return this.id != null && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public Quotation getQuotation() {
        return this.quotation;
    }

    public QuotationPosition getQuotationPosition() {
        return this.quotationPosition;
    }

    public QuotationPosition getJumboQuotationPosition() {
        return this.jumboQuotationPosition;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public User getAssignedUser() {
        return this.assignedUser;
    }

    public String getSurrogatePositionNumber() {
        return this.surrogatePositionNumber;
    }

    public String getJumboPositionSurrogatePositionNumber() {
        return this.jumboPositionSurrogatePositionNumber;
    }

    public String getQuotationPositionNumber() {
        return this.quotationPositionNumber;
    }

    public String getPositionNumberExternal() {
        return this.positionNumberExternal;
    }

    public Integer getQuotationSubPositionNumber() {
        return this.quotationSubPositionNumber;
    }

    public LocalDate getAccountingMonth() {
        return this.accountingMonth;
    }

    public Long getAddendumNumber() {
        return this.addendumNumber;
    }

    public String getGroupingElementLevel1() {
        return this.groupingElementLevel1;
    }

    public String getGroupingElementLevel2() {
        return this.groupingElementLevel2;
    }

    public String getGroupingElementLevel3() {
        return this.groupingElementLevel3;
    }

    public String getGroupingElementLevel4() {
        return this.groupingElementLevel4;
    }

    public String getFlagAlternativePosition() {
        return this.flagAlternativePosition;
    }

    public EAlternativePositionType getAlternativePositionType() {
        return this.alternativePositionType;
    }

    public Boolean getFlagFlatRate() {
        return this.flagFlatRate;
    }

    public Boolean getFlagCancel() {
        return this.flagCancel;
    }

    public Boolean getFlagNotInQuotation() {
        return this.flagNotInQuotation;
    }

    public Integer getSequenceNumberInvoice() {
        return this.sequenceNumberInvoice;
    }

    public Integer getSequenceNumberMeasurementStandard() {
        return this.sequenceNumberMeasurementStandard;
    }

    public Integer getSequenceNumberMeasurementTransposed() {
        return this.sequenceNumberMeasurementTransposed;
    }

    public Integer getColumnIndexTransposed() {
        return this.columnIndexTransposed;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getFactor1() {
        return this.factor1;
    }

    public BigDecimal getFactor2() {
        return this.factor2;
    }

    public BigDecimal getFactor3() {
        return this.factor3;
    }

    public BigDecimal getProduct() {
        return this.product;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getJumboPositionUnit() {
        return this.jumboPositionUnit;
    }

    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getJumboPositionShortText() {
        return this.jumboPositionShortText;
    }

    public String getLongText() {
        return this.longText;
    }

    public BigDecimal getInternalWagePerUnit() {
        return this.internalWagePerUnit;
    }

    public BigDecimal getInternalWageAggregated() {
        return this.internalWageAggregated;
    }

    public BigDecimal getMaterialSellingPricePerUnit() {
        return this.materialSellingPricePerUnit;
    }

    public BigDecimal getMaterialSellingPriceAggregated() {
        return this.materialSellingPriceAggregated;
    }

    public BigDecimal getMaterialPurchasePriceExcludingDiscountAggregated() {
        return this.materialPurchasePriceExcludingDiscountAggregated;
    }

    public BigDecimal getMaterialPurchasePriceIncludingDiscountAggregated() {
        return this.materialPurchasePriceIncludingDiscountAggregated;
    }

    public BigDecimal getMaterialPurchasePriceDiscount() {
        return this.materialPurchasePriceDiscount;
    }

    public BigDecimal getMaterialPurchasePriceExcludingDiscountPerUnit() {
        return this.materialPurchasePriceExcludingDiscountPerUnit;
    }

    public BigDecimal getMaterialPurchasePriceIncludingDiscountPerUnit() {
        return this.materialPurchasePriceIncludingDiscountPerUnit;
    }

    public BigDecimal getCompanyWagePerUnit() {
        return this.companyWagePerUnit;
    }

    public BigDecimal getCompanyWageAggregated() {
        return this.companyWageAggregated;
    }

    @Deprecated
    public BigDecimal getCompanyWageAggregatedDiscount() {
        return this.companyWageAggregatedDiscount;
    }

    @Deprecated
    public BigDecimal getMaterialSellingPriceAggregatedDiscount() {
        return this.materialSellingPriceAggregatedDiscount;
    }

    @Deprecated
    public BigDecimal getPriceAggregatedDiscount() {
        return this.priceAggregatedDiscount;
    }

    @Deprecated
    public BigDecimal getDiscount() {
        return this.discount;
    }

    @Deprecated
    public BigDecimal getOtherDiscount() {
        return this.otherDiscount;
    }

    public BigDecimal getInternalSquadWagePerUnit() {
        return this.internalSquadWagePerUnit;
    }

    public BigDecimal getInternalSquadWageAggregated() {
        return this.internalSquadWageAggregated;
    }

    public String getArticleCode() {
        return this.articleCode;
    }

    public String getArticleName() {
        return this.articleName;
    }

    public String getSupplierCode() {
        return this.supplierCode;
    }

    public BigDecimal getPricePerUnit() {
        return this.pricePerUnit;
    }

    public BigDecimal getJumboPositionPricePerUnit() {
        return this.jumboPositionPricePerUnit;
    }

    public BigDecimal getPriceAggregated() {
        return this.priceAggregated;
    }

    public EPositionType getPositionType() {
        return this.positionType;
    }

    public BigDecimal getMaterialPercentage() {
        return this.materialPercentage;
    }

    public BigDecimal getWagePercentage() {
        return this.wagePercentage;
    }

    public BigDecimal getAggregatedPercentage() {
        return this.aggregatedPercentage;
    }

    public BigDecimal getExternalServicePurchasePricePerUnit() {
        return this.externalServicePurchasePricePerUnit;
    }

    public BigDecimal getExternalServicePurchasePriceAggregated() {
        return this.externalServicePurchasePriceAggregated;
    }

    public BigDecimal getExternalServicePercentage() {
        return this.externalServicePercentage;
    }

    public BigDecimal getExternalServiceSellingPricePerUnit() {
        return this.externalServiceSellingPricePerUnit;
    }

    public BigDecimal getExternalServiceSellingPriceAggregated() {
        return this.externalServiceSellingPriceAggregated;
    }

    public Boolean getFlagFeePosition() {
        return this.flagFeePosition;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
    }

    public void setQuotation(Quotation quotation) {
        this.quotation = quotation;
    }

    public void setQuotationPosition(QuotationPosition quotationPosition) {
        this.quotationPosition = quotationPosition;
    }

    public void setJumboQuotationPosition(QuotationPosition jumboQuotationPosition) {
        this.jumboQuotationPosition = jumboQuotationPosition;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public void setAssignedUser(User assignedUser) {
        this.assignedUser = assignedUser;
    }

    public void setSurrogatePositionNumber(String surrogatePositionNumber) {
        this.surrogatePositionNumber = surrogatePositionNumber;
    }

    public void setJumboPositionSurrogatePositionNumber(String jumboPositionSurrogatePositionNumber) {
        this.jumboPositionSurrogatePositionNumber = jumboPositionSurrogatePositionNumber;
    }

    public void setQuotationPositionNumber(String quotationPositionNumber) {
        this.quotationPositionNumber = quotationPositionNumber;
    }

    public void setPositionNumberExternal(String positionNumberExternal) {
        this.positionNumberExternal = positionNumberExternal;
    }

    public void setQuotationSubPositionNumber(Integer quotationSubPositionNumber) {
        this.quotationSubPositionNumber = quotationSubPositionNumber;
    }

    public void setAccountingMonth(LocalDate accountingMonth) {
        this.accountingMonth = accountingMonth;
    }

    public void setAddendumNumber(Long addendumNumber) {
        this.addendumNumber = addendumNumber;
    }

    public void setGroupingElementLevel1(String groupingElementLevel1) {
        this.groupingElementLevel1 = groupingElementLevel1;
    }

    public void setGroupingElementLevel2(String groupingElementLevel2) {
        this.groupingElementLevel2 = groupingElementLevel2;
    }

    public void setGroupingElementLevel3(String groupingElementLevel3) {
        this.groupingElementLevel3 = groupingElementLevel3;
    }

    public void setGroupingElementLevel4(String groupingElementLevel4) {
        this.groupingElementLevel4 = groupingElementLevel4;
    }

    public void setFlagAlternativePosition(String flagAlternativePosition) {
        this.flagAlternativePosition = flagAlternativePosition;
    }

    public void setAlternativePositionType(EAlternativePositionType alternativePositionType) {
        this.alternativePositionType = alternativePositionType;
    }

    public void setFlagFlatRate(Boolean flagFlatRate) {
        this.flagFlatRate = flagFlatRate;
    }

    public void setFlagCancel(Boolean flagCancel) {
        this.flagCancel = flagCancel;
    }

    public void setFlagNotInQuotation(Boolean flagNotInQuotation) {
        this.flagNotInQuotation = flagNotInQuotation;
    }

    public void setSequenceNumberInvoice(Integer sequenceNumberInvoice) {
        this.sequenceNumberInvoice = sequenceNumberInvoice;
    }

    public void setSequenceNumberMeasurementStandard(Integer sequenceNumberMeasurementStandard) {
        this.sequenceNumberMeasurementStandard = sequenceNumberMeasurementStandard;
    }

    public void setSequenceNumberMeasurementTransposed(Integer sequenceNumberMeasurementTransposed) {
        this.sequenceNumberMeasurementTransposed = sequenceNumberMeasurementTransposed;
    }

    public void setColumnIndexTransposed(Integer columnIndexTransposed) {
        this.columnIndexTransposed = columnIndexTransposed;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setFactor1(BigDecimal factor1) {
        this.factor1 = factor1;
    }

    public void setFactor2(BigDecimal factor2) {
        this.factor2 = factor2;
    }

    public void setFactor3(BigDecimal factor3) {
        this.factor3 = factor3;
    }

    public void setProduct(BigDecimal product) {
        this.product = product;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setJumboPositionUnit(String jumboPositionUnit) {
        this.jumboPositionUnit = jumboPositionUnit;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    public void setJumboPositionShortText(String jumboPositionShortText) {
        this.jumboPositionShortText = jumboPositionShortText;
    }

    public void setLongText(String longText) {
        this.longText = longText;
    }

    public void setInternalWagePerUnit(BigDecimal internalWagePerUnit) {
        this.internalWagePerUnit = internalWagePerUnit;
    }

    public void setInternalWageAggregated(BigDecimal internalWageAggregated) {
        this.internalWageAggregated = internalWageAggregated;
    }

    public void setMaterialSellingPricePerUnit(BigDecimal materialSellingPricePerUnit) {
        this.materialSellingPricePerUnit = materialSellingPricePerUnit;
    }

    public void setMaterialSellingPriceAggregated(BigDecimal materialSellingPriceAggregated) {
        this.materialSellingPriceAggregated = materialSellingPriceAggregated;
    }

    public void setMaterialPurchasePriceExcludingDiscountAggregated(BigDecimal materialPurchasePriceExcludingDiscountAggregated) {
        this.materialPurchasePriceExcludingDiscountAggregated = materialPurchasePriceExcludingDiscountAggregated;
    }

    public void setMaterialPurchasePriceIncludingDiscountAggregated(BigDecimal materialPurchasePriceIncludingDiscountAggregated) {
        this.materialPurchasePriceIncludingDiscountAggregated = materialPurchasePriceIncludingDiscountAggregated;
    }

    public void setMaterialPurchasePriceDiscount(BigDecimal materialPurchasePriceDiscount) {
        this.materialPurchasePriceDiscount = materialPurchasePriceDiscount;
    }

    public void setMaterialPurchasePriceExcludingDiscountPerUnit(BigDecimal materialPurchasePriceExcludingDiscountPerUnit) {
        this.materialPurchasePriceExcludingDiscountPerUnit = materialPurchasePriceExcludingDiscountPerUnit;
    }

    public void setMaterialPurchasePriceIncludingDiscountPerUnit(BigDecimal materialPurchasePriceIncludingDiscountPerUnit) {
        this.materialPurchasePriceIncludingDiscountPerUnit = materialPurchasePriceIncludingDiscountPerUnit;
    }

    public void setCompanyWagePerUnit(BigDecimal companyWagePerUnit) {
        this.companyWagePerUnit = companyWagePerUnit;
    }

    public void setCompanyWageAggregated(BigDecimal companyWageAggregated) {
        this.companyWageAggregated = companyWageAggregated;
    }

    @Deprecated
    public void setCompanyWageAggregatedDiscount(BigDecimal companyWageAggregatedDiscount) {
        this.companyWageAggregatedDiscount = companyWageAggregatedDiscount;
    }

    @Deprecated
    public void setMaterialSellingPriceAggregatedDiscount(BigDecimal materialSellingPriceAggregatedDiscount) {
        this.materialSellingPriceAggregatedDiscount = materialSellingPriceAggregatedDiscount;
    }

    @Deprecated
    public void setPriceAggregatedDiscount(BigDecimal priceAggregatedDiscount) {
        this.priceAggregatedDiscount = priceAggregatedDiscount;
    }

    @Deprecated
    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    @Deprecated
    public void setOtherDiscount(BigDecimal otherDiscount) {
        this.otherDiscount = otherDiscount;
    }

    public void setInternalSquadWagePerUnit(BigDecimal internalSquadWagePerUnit) {
        this.internalSquadWagePerUnit = internalSquadWagePerUnit;
    }

    public void setInternalSquadWageAggregated(BigDecimal internalSquadWageAggregated) {
        this.internalSquadWageAggregated = internalSquadWageAggregated;
    }

    public void setArticleCode(String articleCode) {
        this.articleCode = articleCode;
    }

    public void setArticleName(String articleName) {
        this.articleName = articleName;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public void setPricePerUnit(BigDecimal pricePerUnit) {
        this.pricePerUnit = pricePerUnit;
    }

    public void setJumboPositionPricePerUnit(BigDecimal jumboPositionPricePerUnit) {
        this.jumboPositionPricePerUnit = jumboPositionPricePerUnit;
    }

    public void setPriceAggregated(BigDecimal priceAggregated) {
        this.priceAggregated = priceAggregated;
    }

    public void setPositionType(EPositionType positionType) {
        this.positionType = positionType;
    }

    public void setMaterialPercentage(BigDecimal materialPercentage) {
        this.materialPercentage = materialPercentage;
    }

    public void setWagePercentage(BigDecimal wagePercentage) {
        this.wagePercentage = wagePercentage;
    }

    public void setAggregatedPercentage(BigDecimal aggregatedPercentage) {
        this.aggregatedPercentage = aggregatedPercentage;
    }

    public void setExternalServicePurchasePricePerUnit(BigDecimal externalServicePurchasePricePerUnit) {
        this.externalServicePurchasePricePerUnit = externalServicePurchasePricePerUnit;
    }

    public void setExternalServicePurchasePriceAggregated(BigDecimal externalServicePurchasePriceAggregated) {
        this.externalServicePurchasePriceAggregated = externalServicePurchasePriceAggregated;
    }

    public void setExternalServicePercentage(BigDecimal externalServicePercentage) {
        this.externalServicePercentage = externalServicePercentage;
    }

    public void setExternalServiceSellingPricePerUnit(BigDecimal externalServiceSellingPricePerUnit) {
        this.externalServiceSellingPricePerUnit = externalServiceSellingPricePerUnit;
    }

    public void setExternalServiceSellingPriceAggregated(BigDecimal externalServiceSellingPriceAggregated) {
        this.externalServiceSellingPriceAggregated = externalServiceSellingPriceAggregated;
    }

    public void setFlagFeePosition(Boolean flagFeePosition) {
        this.flagFeePosition = flagFeePosition;
    }

    public String toString() {
        return "MeasurementPosition(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", surrogatePositionNumber=" + this.getSurrogatePositionNumber() + ", jumboPositionSurrogatePositionNumber=" + this.getJumboPositionSurrogatePositionNumber() + ", quotationPositionNumber=" + this.getQuotationPositionNumber() + ", positionNumberExternal=" + this.getPositionNumberExternal() + ", quotationSubPositionNumber=" + this.getQuotationSubPositionNumber() + ", accountingMonth=" + String.valueOf(this.getAccountingMonth()) + ", addendumNumber=" + this.getAddendumNumber() + ", groupingElementLevel1=" + this.getGroupingElementLevel1() + ", groupingElementLevel2=" + this.getGroupingElementLevel2() + ", groupingElementLevel3=" + this.getGroupingElementLevel3() + ", groupingElementLevel4=" + this.getGroupingElementLevel4() + ", flagAlternativePosition=" + this.getFlagAlternativePosition() + ", alternativePositionType=" + String.valueOf(this.getAlternativePositionType()) + ", flagFlatRate=" + this.getFlagFlatRate() + ", flagCancel=" + this.getFlagCancel() + ", flagNotInQuotation=" + this.getFlagNotInQuotation() + ", sequenceNumberInvoice=" + this.getSequenceNumberInvoice() + ", sequenceNumberMeasurementStandard=" + this.getSequenceNumberMeasurementStandard() + ", sequenceNumberMeasurementTransposed=" + this.getSequenceNumberMeasurementTransposed() + ", columnIndexTransposed=" + this.getColumnIndexTransposed() + ", amount=" + String.valueOf(this.getAmount()) + ", factor1=" + String.valueOf(this.getFactor1()) + ", factor2=" + String.valueOf(this.getFactor2()) + ", factor3=" + String.valueOf(this.getFactor3()) + ", product=" + String.valueOf(this.getProduct()) + ", remarks=" + this.getRemarks() + ", unit=" + this.getUnit() + ", jumboPositionUnit=" + this.getJumboPositionUnit() + ", unitAmount=" + String.valueOf(this.getUnitAmount()) + ", shortText=" + this.getShortText() + ", jumboPositionShortText=" + this.getJumboPositionShortText() + ", longText=" + this.getLongText() + ", internalWagePerUnit=" + String.valueOf(this.getInternalWagePerUnit()) + ", internalWageAggregated=" + String.valueOf(this.getInternalWageAggregated()) + ", materialSellingPricePerUnit=" + String.valueOf(this.getMaterialSellingPricePerUnit()) + ", materialSellingPriceAggregated=" + String.valueOf(this.getMaterialSellingPriceAggregated()) + ", materialPurchasePriceExcludingDiscountAggregated=" + String.valueOf(this.getMaterialPurchasePriceExcludingDiscountAggregated()) + ", materialPurchasePriceIncludingDiscountAggregated=" + String.valueOf(this.getMaterialPurchasePriceIncludingDiscountAggregated()) + ", materialPurchasePriceDiscount=" + String.valueOf(this.getMaterialPurchasePriceDiscount()) + ", materialPurchasePriceExcludingDiscountPerUnit=" + String.valueOf(this.getMaterialPurchasePriceExcludingDiscountPerUnit()) + ", materialPurchasePriceIncludingDiscountPerUnit=" + String.valueOf(this.getMaterialPurchasePriceIncludingDiscountPerUnit()) + ", companyWagePerUnit=" + String.valueOf(this.getCompanyWagePerUnit()) + ", companyWageAggregated=" + String.valueOf(this.getCompanyWageAggregated()) + ", companyWageAggregatedDiscount=" + String.valueOf(this.getCompanyWageAggregatedDiscount()) + ", materialSellingPriceAggregatedDiscount=" + String.valueOf(this.getMaterialSellingPriceAggregatedDiscount()) + ", priceAggregatedDiscount=" + String.valueOf(this.getPriceAggregatedDiscount()) + ", discount=" + String.valueOf(this.getDiscount()) + ", otherDiscount=" + String.valueOf(this.getOtherDiscount()) + ", internalSquadWagePerUnit=" + String.valueOf(this.getInternalSquadWagePerUnit()) + ", internalSquadWageAggregated=" + String.valueOf(this.getInternalSquadWageAggregated()) + ", articleCode=" + this.getArticleCode() + ", articleName=" + this.getArticleName() + ", supplierCode=" + this.getSupplierCode() + ", pricePerUnit=" + String.valueOf(this.getPricePerUnit()) + ", jumboPositionPricePerUnit=" + String.valueOf(this.getJumboPositionPricePerUnit()) + ", priceAggregated=" + String.valueOf(this.getPriceAggregated()) + ", positionType=" + String.valueOf(this.getPositionType()) + ", materialPercentage=" + String.valueOf(this.getMaterialPercentage()) + ", wagePercentage=" + String.valueOf(this.getWagePercentage()) + ", aggregatedPercentage=" + String.valueOf(this.getAggregatedPercentage()) + ", externalServicePurchasePricePerUnit=" + String.valueOf(this.getExternalServicePurchasePricePerUnit()) + ", externalServicePurchasePriceAggregated=" + String.valueOf(this.getExternalServicePurchasePriceAggregated()) + ", externalServicePercentage=" + String.valueOf(this.getExternalServicePercentage()) + ", externalServiceSellingPricePerUnit=" + String.valueOf(this.getExternalServiceSellingPricePerUnit()) + ", externalServiceSellingPriceAggregated=" + String.valueOf(this.getExternalServiceSellingPriceAggregated()) + ", flagFeePosition=" + this.getFlagFeePosition() + ")";
    }
}

