/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.measurement;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.internal.quotation.ECostUnitCEViewMode;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.InvoiceMeasurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.MeasurementTransposedRemark;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementOrigin;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementViewType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.User;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Hibernate;

@Entity(name="Measurement")
@Table(name="MEASUREMENT")
public class Measurement
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MEASUREMENT_SEQ")
    @SequenceGenerator(sequenceName="MEASUREMENT_SEQ", allocationSize=1, name="MEASUREMENT_SEQ")
    private Long id;
    @Column(name="reference_id", length=50)
    private String referenceId;
    @Column(name="origin", length=50)
    @Enumerated(value=EnumType.STRING)
    private EMeasurementOrigin origin;
    @Column(name="last_origin", length=50)
    @Enumerated(value=EnumType.STRING)
    private EMeasurementOrigin lastOrigin;
    @Column(name="cost_unit_ce_view_mode", length=50)
    @Enumerated(value=EnumType.STRING)
    private ECostUnitCEViewMode costUnitCEViewMode;
    @Column(name="measurement_number", length=50)
    private String measurementNumber;
    @Column(name="original_measurement_number", length=50)
    private String originalMeasurementNumber;
    @Column(name="sheet_number_value")
    private Long sheetNumberValue;
    @JoinColumn(name="assigned_user_id")
    @ManyToOne(optional=true, fetch=FetchType.EAGER)
    private User assignedUser;
    @JoinColumn(name="quotation_id")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    private Quotation quotation;
    @Column(name="search_index_state", length=50)
    @Enumerated(value=EnumType.STRING)
    private ESearchIndexState searchIndexState;
    @Column(name="measurement_type", length=50)
    @Enumerated(value=EnumType.STRING)
    private EMeasurementType measurementType;
    @Column(name="measurement_view_type", length=50)
    @Enumerated(value=EnumType.STRING)
    private EMeasurementViewType measurementViewType;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks", length=250)
    private String remarks;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks_internal", length=250)
    private String remarksInternal;
    @Convert(converter=NullStringConverter.class)
    @Column(name="construction_site", length=200)
    private String constructionSite;
    @Convert(converter=NullStringConverter.class)
    @Column(name="person_responsible_at_customer", length=250)
    private String personResponsibleAtCustomer;
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_area", length=50)
    private String customerArea;
    @Column(name="project_execution_start_date")
    private LocalDate projectExecutionStartDate;
    @Column(name="project_execution_end_date")
    private LocalDate projectExecutionEndDate;
    @Column(name="accounting_month")
    private LocalDate accountingMonth;
    @Column(name="accounting_month_planned")
    private LocalDate accountingMonthPlanned;
    @Deprecated
    @Column(name="wage_overall")
    private BigDecimal wageOverall;
    @Column(name="internal_wage_overall")
    private BigDecimal internalWageOverall;
    @Column(name="squad_wage_overall")
    private BigDecimal squadWageOverall;
    @Column(name="value_overall")
    private BigDecimal valueOverall;
    @Column(name="company_wage_overall")
    private BigDecimal companyWageOverall;
    @Column(name="mat_purchase_price_overall")
    private BigDecimal materialPurchasePriceOverall;
    @Column(name="mat_selling_price_overall")
    private BigDecimal materialSellingPriceOverall;
    @Column(name="es_purchase_price_overall")
    private BigDecimal externalServicePurchasePriceOverall;
    @Column(name="es_selling_price_overall")
    private BigDecimal externalServiceSellingPriceOverall;
    @Convert(converter=NullStringConverter.class)
    @Column(name="catch_all", length=250)
    private String catchAll;
    @Convert(converter=NullStringConverter.class)
    @Column(name="calculated_addendum_numbers", length=1000)
    private String addendumNumbers;
    @Convert(converter=NullStringConverter.class)
    @Column(name="import_errors", length=2000)
    private String importErrors;
    @Convert(converter=NullStringConverter.class)
    @Column(name="import_file_name", length=250)
    private String importFileName;
    @OneToOne(fetch=FetchType.EAGER, mappedBy="measurement", cascade={CascadeType.ALL})
    private ReleaseOrder releaseOrder;
    @JoinColumn(name="copied_from_measurement_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Measurement copiedFromMeasurement;
    @JoinColumn(name="measurement_state_id")
    @ManyToOne(fetch=FetchType.EAGER)
    private MeasurementState measurementState;
    @JoinColumn(name="created_by_user_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private User createdByUser;
    @JoinColumn(name="invoice_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Invoice invoice;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="measurement", cascade={CascadeType.ALL})
    private List<MeasurementPosition> measurementPositions;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="measurement", cascade={CascadeType.ALL})
    private Set<MeasurementTransposedRemark> measurementTransposedRemarks;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="measurement", cascade={CascadeType.ALL})
    private Set<InvoiceMeasurement> invoiceMeasurements;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="measurement", cascade={CascadeType.ALL})
    private Set<MeasurementState> measurementStates;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        Measurement that = (Measurement)o;
        return this.id != null && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public EMeasurementOrigin getOrigin() {
        return this.origin;
    }

    public EMeasurementOrigin getLastOrigin() {
        return this.lastOrigin;
    }

    public ECostUnitCEViewMode getCostUnitCEViewMode() {
        return this.costUnitCEViewMode;
    }

    public String getMeasurementNumber() {
        return this.measurementNumber;
    }

    public String getOriginalMeasurementNumber() {
        return this.originalMeasurementNumber;
    }

    public Long getSheetNumberValue() {
        return this.sheetNumberValue;
    }

    public User getAssignedUser() {
        return this.assignedUser;
    }

    public Quotation getQuotation() {
        return this.quotation;
    }

    public ESearchIndexState getSearchIndexState() {
        return this.searchIndexState;
    }

    public EMeasurementType getMeasurementType() {
        return this.measurementType;
    }

    public EMeasurementViewType getMeasurementViewType() {
        return this.measurementViewType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getRemarksInternal() {
        return this.remarksInternal;
    }

    public String getConstructionSite() {
        return this.constructionSite;
    }

    public String getPersonResponsibleAtCustomer() {
        return this.personResponsibleAtCustomer;
    }

    public String getCustomerArea() {
        return this.customerArea;
    }

    public LocalDate getProjectExecutionStartDate() {
        return this.projectExecutionStartDate;
    }

    public LocalDate getProjectExecutionEndDate() {
        return this.projectExecutionEndDate;
    }

    public LocalDate getAccountingMonth() {
        return this.accountingMonth;
    }

    public LocalDate getAccountingMonthPlanned() {
        return this.accountingMonthPlanned;
    }

    @Deprecated
    public BigDecimal getWageOverall() {
        return this.wageOverall;
    }

    public BigDecimal getInternalWageOverall() {
        return this.internalWageOverall;
    }

    public BigDecimal getSquadWageOverall() {
        return this.squadWageOverall;
    }

    public BigDecimal getValueOverall() {
        return this.valueOverall;
    }

    public BigDecimal getCompanyWageOverall() {
        return this.companyWageOverall;
    }

    public BigDecimal getMaterialPurchasePriceOverall() {
        return this.materialPurchasePriceOverall;
    }

    public BigDecimal getMaterialSellingPriceOverall() {
        return this.materialSellingPriceOverall;
    }

    public BigDecimal getExternalServicePurchasePriceOverall() {
        return this.externalServicePurchasePriceOverall;
    }

    public BigDecimal getExternalServiceSellingPriceOverall() {
        return this.externalServiceSellingPriceOverall;
    }

    public String getCatchAll() {
        return this.catchAll;
    }

    public String getAddendumNumbers() {
        return this.addendumNumbers;
    }

    public String getImportErrors() {
        return this.importErrors;
    }

    public String getImportFileName() {
        return this.importFileName;
    }

    public ReleaseOrder getReleaseOrder() {
        return this.releaseOrder;
    }

    public Measurement getCopiedFromMeasurement() {
        return this.copiedFromMeasurement;
    }

    public MeasurementState getMeasurementState() {
        return this.measurementState;
    }

    public User getCreatedByUser() {
        return this.createdByUser;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public List<MeasurementPosition> getMeasurementPositions() {
        return this.measurementPositions;
    }

    public Set<MeasurementTransposedRemark> getMeasurementTransposedRemarks() {
        return this.measurementTransposedRemarks;
    }

    public Set<InvoiceMeasurement> getInvoiceMeasurements() {
        return this.invoiceMeasurements;
    }

    public Set<MeasurementState> getMeasurementStates() {
        return this.measurementStates;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setOrigin(EMeasurementOrigin origin) {
        this.origin = origin;
    }

    public void setLastOrigin(EMeasurementOrigin lastOrigin) {
        this.lastOrigin = lastOrigin;
    }

    public void setCostUnitCEViewMode(ECostUnitCEViewMode costUnitCEViewMode) {
        this.costUnitCEViewMode = costUnitCEViewMode;
    }

    public void setMeasurementNumber(String measurementNumber) {
        this.measurementNumber = measurementNumber;
    }

    public void setOriginalMeasurementNumber(String originalMeasurementNumber) {
        this.originalMeasurementNumber = originalMeasurementNumber;
    }

    public void setSheetNumberValue(Long sheetNumberValue) {
        this.sheetNumberValue = sheetNumberValue;
    }

    public void setAssignedUser(User assignedUser) {
        this.assignedUser = assignedUser;
    }

    public void setQuotation(Quotation quotation) {
        this.quotation = quotation;
    }

    public void setSearchIndexState(ESearchIndexState searchIndexState) {
        this.searchIndexState = searchIndexState;
    }

    public void setMeasurementType(EMeasurementType measurementType) {
        this.measurementType = measurementType;
    }

    public void setMeasurementViewType(EMeasurementViewType measurementViewType) {
        this.measurementViewType = measurementViewType;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setRemarksInternal(String remarksInternal) {
        this.remarksInternal = remarksInternal;
    }

    public void setConstructionSite(String constructionSite) {
        this.constructionSite = constructionSite;
    }

    public void setPersonResponsibleAtCustomer(String personResponsibleAtCustomer) {
        this.personResponsibleAtCustomer = personResponsibleAtCustomer;
    }

    public void setCustomerArea(String customerArea) {
        this.customerArea = customerArea;
    }

    public void setProjectExecutionStartDate(LocalDate projectExecutionStartDate) {
        this.projectExecutionStartDate = projectExecutionStartDate;
    }

    public void setProjectExecutionEndDate(LocalDate projectExecutionEndDate) {
        this.projectExecutionEndDate = projectExecutionEndDate;
    }

    public void setAccountingMonth(LocalDate accountingMonth) {
        this.accountingMonth = accountingMonth;
    }

    public void setAccountingMonthPlanned(LocalDate accountingMonthPlanned) {
        this.accountingMonthPlanned = accountingMonthPlanned;
    }

    @Deprecated
    public void setWageOverall(BigDecimal wageOverall) {
        this.wageOverall = wageOverall;
    }

    public void setInternalWageOverall(BigDecimal internalWageOverall) {
        this.internalWageOverall = internalWageOverall;
    }

    public void setSquadWageOverall(BigDecimal squadWageOverall) {
        this.squadWageOverall = squadWageOverall;
    }

    public void setValueOverall(BigDecimal valueOverall) {
        this.valueOverall = valueOverall;
    }

    public void setCompanyWageOverall(BigDecimal companyWageOverall) {
        this.companyWageOverall = companyWageOverall;
    }

    public void setMaterialPurchasePriceOverall(BigDecimal materialPurchasePriceOverall) {
        this.materialPurchasePriceOverall = materialPurchasePriceOverall;
    }

    public void setMaterialSellingPriceOverall(BigDecimal materialSellingPriceOverall) {
        this.materialSellingPriceOverall = materialSellingPriceOverall;
    }

    public void setExternalServicePurchasePriceOverall(BigDecimal externalServicePurchasePriceOverall) {
        this.externalServicePurchasePriceOverall = externalServicePurchasePriceOverall;
    }

    public void setExternalServiceSellingPriceOverall(BigDecimal externalServiceSellingPriceOverall) {
        this.externalServiceSellingPriceOverall = externalServiceSellingPriceOverall;
    }

    public void setCatchAll(String catchAll) {
        this.catchAll = catchAll;
    }

    public void setAddendumNumbers(String addendumNumbers) {
        this.addendumNumbers = addendumNumbers;
    }

    public void setImportErrors(String importErrors) {
        this.importErrors = importErrors;
    }

    public void setImportFileName(String importFileName) {
        this.importFileName = importFileName;
    }

    public void setReleaseOrder(ReleaseOrder releaseOrder) {
        this.releaseOrder = releaseOrder;
    }

    public void setCopiedFromMeasurement(Measurement copiedFromMeasurement) {
        this.copiedFromMeasurement = copiedFromMeasurement;
    }

    public void setMeasurementState(MeasurementState measurementState) {
        this.measurementState = measurementState;
    }

    public void setCreatedByUser(User createdByUser) {
        this.createdByUser = createdByUser;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public void setMeasurementPositions(List<MeasurementPosition> measurementPositions) {
        this.measurementPositions = measurementPositions;
    }

    public void setMeasurementTransposedRemarks(Set<MeasurementTransposedRemark> measurementTransposedRemarks) {
        this.measurementTransposedRemarks = measurementTransposedRemarks;
    }

    public void setInvoiceMeasurements(Set<InvoiceMeasurement> invoiceMeasurements) {
        this.invoiceMeasurements = invoiceMeasurements;
    }

    public void setMeasurementStates(Set<MeasurementState> measurementStates) {
        this.measurementStates = measurementStates;
    }

    public String toString() {
        return "Measurement(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", origin=" + String.valueOf(this.getOrigin()) + ", lastOrigin=" + String.valueOf(this.getLastOrigin()) + ", costUnitCEViewMode=" + String.valueOf(this.getCostUnitCEViewMode()) + ", measurementNumber=" + this.getMeasurementNumber() + ", originalMeasurementNumber=" + this.getOriginalMeasurementNumber() + ", sheetNumberValue=" + this.getSheetNumberValue() + ", searchIndexState=" + String.valueOf(this.getSearchIndexState()) + ", measurementType=" + String.valueOf(this.getMeasurementType()) + ", measurementViewType=" + String.valueOf(this.getMeasurementViewType()) + ", remarks=" + this.getRemarks() + ", remarksInternal=" + this.getRemarksInternal() + ", constructionSite=" + this.getConstructionSite() + ", personResponsibleAtCustomer=" + this.getPersonResponsibleAtCustomer() + ", customerArea=" + this.getCustomerArea() + ", projectExecutionStartDate=" + String.valueOf(this.getProjectExecutionStartDate()) + ", projectExecutionEndDate=" + String.valueOf(this.getProjectExecutionEndDate()) + ", accountingMonth=" + String.valueOf(this.getAccountingMonth()) + ", accountingMonthPlanned=" + String.valueOf(this.getAccountingMonthPlanned()) + ", wageOverall=" + String.valueOf(this.getWageOverall()) + ", internalWageOverall=" + String.valueOf(this.getInternalWageOverall()) + ", squadWageOverall=" + String.valueOf(this.getSquadWageOverall()) + ", valueOverall=" + String.valueOf(this.getValueOverall()) + ", companyWageOverall=" + String.valueOf(this.getCompanyWageOverall()) + ", materialPurchasePriceOverall=" + String.valueOf(this.getMaterialPurchasePriceOverall()) + ", materialSellingPriceOverall=" + String.valueOf(this.getMaterialSellingPriceOverall()) + ", externalServicePurchasePriceOverall=" + String.valueOf(this.getExternalServicePurchasePriceOverall()) + ", externalServiceSellingPriceOverall=" + String.valueOf(this.getExternalServiceSellingPriceOverall()) + ", catchAll=" + this.getCatchAll() + ", addendumNumbers=" + this.getAddendumNumbers() + ", importErrors=" + this.getImportErrors() + ", importFileName=" + this.getImportFileName() + ")";
    }
}

