/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.invoice;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.invoice.EInvoicePositionType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="InvoicePosition")
@Table(name="INVOICE_POSITION")
public class InvoicePosition
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="INVOICE_POSITION_SEQ")
    @SequenceGenerator(sequenceName="INVOICE_POSITION_SEQ", allocationSize=1, name="INVOICE_POSITION_SEQ")
    private Long id;
    @Column(name="reference_id", length=50)
    private String referenceId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="invoice_position_type", length=50)
    public EInvoicePositionType invoicePositionType;
    @Column(name="sequence_number")
    private Integer sequenceNumber;
    @JoinColumn(name="invoice_id")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    private Invoice invoice;
    @JoinColumn(name="measurement_position_id")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    private MeasurementPosition measurementPosition;
    @Column(name="position_number", length=20)
    private String positionNumber;
    @Column(name="amount")
    private BigDecimal amount;
    @Column(name="factor_1")
    private BigDecimal factor1;
    @Column(name="factor_2")
    private BigDecimal factor2;
    @Column(name="factor_3")
    private BigDecimal factor3;
    @Column(name="product")
    private BigDecimal product;
    @Column(name="unit", length=50)
    private String unit;
    @Convert(converter=NullStringConverter.class)
    @Column(name="short_text", length=500)
    private String shortText;
    @Convert(converter=NullStringConverter.class)
    @Lob
    @Column(name="remarks", length=3000)
    private String remarks;
    @Column(name="mat_purchase_price_per_unit")
    private BigDecimal materialPurchasePricePerUnit;
    @Column(name="mat_purchase_price_agg")
    private BigDecimal materialPurchasePriceAgg;
    @Column(name="mat_selling_price_per_unit")
    private BigDecimal materialSellingPricePerUnit;
    @Column(name="mat_selling_price_agg")
    private BigDecimal materialSellingPriceAggregated;
    @Column(name="material_factor")
    private BigDecimal materialFactor;
    @Column(name="price_per_unit")
    private BigDecimal pricePerUnit;
    @Column(name="price_aggregated")
    private BigDecimal priceAggregated;
    @Column(name="addendum_number")
    private Long addendumNumber;
    @Column(name="discount")
    private BigDecimal discount;
    @Column(name="discount_value_aggregated")
    private BigDecimal discountValueAggregated;
    @Column(name="price_aggregated_with_discount")
    private BigDecimal priceAggregatedWithDiscount;
    @Column(name="flag_fee_position")
    private Boolean flagFeePosition;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        InvoicePosition that = (InvoicePosition)o;
        return this.id != null && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public EInvoicePositionType getInvoicePositionType() {
        return this.invoicePositionType;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public MeasurementPosition getMeasurementPosition() {
        return this.measurementPosition;
    }

    public String getPositionNumber() {
        return this.positionNumber;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getFactor1() {
        return this.factor1;
    }

    public BigDecimal getFactor2() {
        return this.factor2;
    }

    public BigDecimal getFactor3() {
        return this.factor3;
    }

    public BigDecimal getProduct() {
        return this.product;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public BigDecimal getMaterialPurchasePricePerUnit() {
        return this.materialPurchasePricePerUnit;
    }

    public BigDecimal getMaterialPurchasePriceAgg() {
        return this.materialPurchasePriceAgg;
    }

    public BigDecimal getMaterialSellingPricePerUnit() {
        return this.materialSellingPricePerUnit;
    }

    public BigDecimal getMaterialSellingPriceAggregated() {
        return this.materialSellingPriceAggregated;
    }

    public BigDecimal getMaterialFactor() {
        return this.materialFactor;
    }

    public BigDecimal getPricePerUnit() {
        return this.pricePerUnit;
    }

    public BigDecimal getPriceAggregated() {
        return this.priceAggregated;
    }

    public Long getAddendumNumber() {
        return this.addendumNumber;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public BigDecimal getDiscountValueAggregated() {
        return this.discountValueAggregated;
    }

    public BigDecimal getPriceAggregatedWithDiscount() {
        return this.priceAggregatedWithDiscount;
    }

    public Boolean getFlagFeePosition() {
        return this.flagFeePosition;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setInvoicePositionType(EInvoicePositionType invoicePositionType) {
        this.invoicePositionType = invoicePositionType;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public void setMeasurementPosition(MeasurementPosition measurementPosition) {
        this.measurementPosition = measurementPosition;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setFactor1(BigDecimal factor1) {
        this.factor1 = factor1;
    }

    public void setFactor2(BigDecimal factor2) {
        this.factor2 = factor2;
    }

    public void setFactor3(BigDecimal factor3) {
        this.factor3 = factor3;
    }

    public void setProduct(BigDecimal product) {
        this.product = product;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setMaterialPurchasePricePerUnit(BigDecimal materialPurchasePricePerUnit) {
        this.materialPurchasePricePerUnit = materialPurchasePricePerUnit;
    }

    public void setMaterialPurchasePriceAgg(BigDecimal materialPurchasePriceAgg) {
        this.materialPurchasePriceAgg = materialPurchasePriceAgg;
    }

    public void setMaterialSellingPricePerUnit(BigDecimal materialSellingPricePerUnit) {
        this.materialSellingPricePerUnit = materialSellingPricePerUnit;
    }

    public void setMaterialSellingPriceAggregated(BigDecimal materialSellingPriceAggregated) {
        this.materialSellingPriceAggregated = materialSellingPriceAggregated;
    }

    public void setMaterialFactor(BigDecimal materialFactor) {
        this.materialFactor = materialFactor;
    }

    public void setPricePerUnit(BigDecimal pricePerUnit) {
        this.pricePerUnit = pricePerUnit;
    }

    public void setPriceAggregated(BigDecimal priceAggregated) {
        this.priceAggregated = priceAggregated;
    }

    public void setAddendumNumber(Long addendumNumber) {
        this.addendumNumber = addendumNumber;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public void setDiscountValueAggregated(BigDecimal discountValueAggregated) {
        this.discountValueAggregated = discountValueAggregated;
    }

    public void setPriceAggregatedWithDiscount(BigDecimal priceAggregatedWithDiscount) {
        this.priceAggregatedWithDiscount = priceAggregatedWithDiscount;
    }

    public void setFlagFeePosition(Boolean flagFeePosition) {
        this.flagFeePosition = flagFeePosition;
    }

    public String toString() {
        return "InvoicePosition(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", invoicePositionType=" + String.valueOf(this.getInvoicePositionType()) + ", sequenceNumber=" + this.getSequenceNumber() + ", positionNumber=" + this.getPositionNumber() + ", amount=" + String.valueOf(this.getAmount()) + ", factor1=" + String.valueOf(this.getFactor1()) + ", factor2=" + String.valueOf(this.getFactor2()) + ", factor3=" + String.valueOf(this.getFactor3()) + ", product=" + String.valueOf(this.getProduct()) + ", unit=" + this.getUnit() + ", shortText=" + this.getShortText() + ", remarks=" + this.getRemarks() + ", materialPurchasePricePerUnit=" + String.valueOf(this.getMaterialPurchasePricePerUnit()) + ", materialPurchasePriceAgg=" + String.valueOf(this.getMaterialPurchasePriceAgg()) + ", materialSellingPricePerUnit=" + String.valueOf(this.getMaterialSellingPricePerUnit()) + ", materialSellingPriceAggregated=" + String.valueOf(this.getMaterialSellingPriceAggregated()) + ", materialFactor=" + String.valueOf(this.getMaterialFactor()) + ", pricePerUnit=" + String.valueOf(this.getPricePerUnit()) + ", priceAggregated=" + String.valueOf(this.getPriceAggregated()) + ", addendumNumber=" + this.getAddendumNumber() + ", discount=" + String.valueOf(this.getDiscount()) + ", discountValueAggregated=" + String.valueOf(this.getDiscountValueAggregated()) + ", priceAggregatedWithDiscount=" + String.valueOf(this.getPriceAggregatedWithDiscount()) + ", flagFeePosition=" + this.getFlagFeePosition() + ")";
    }
}

