/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.invoice;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EInvoiceType implements Translatable
{
    UNKNOWN,
    CREDIT_VOUCHER,
    CUSTOMER_VOUCHER,
    INTERNAL_VOUCHER,
    PARTIAL_INVOICE,
    PARTIAL_FINAL_INVOICE,
    FINAL_INVOICE,
    PARTIAL_CUMULATIVE_INVOICE,
    FINAL_CUMULATIVE_INVOICE,
    CUMULATIVE_INVOICE,
    INVOICE,
    INTERNAL_INVOICE;

    private static final Map<String, EInvoiceType> LOOKUP;
    public static final Iterable<EInvoiceType> INVOICE_TYPES_FOR_SECONDARY_INVOICES;
    public static final Iterable<EInvoiceType> INVOICE_TYPES__UNCLOSE_ON_CANCELLATION;
    public static final Iterable<EInvoiceType> INVOICE_TYPES__VOUCHER_SUM_ON_INVOICE_PRINT;
    public static final Iterable<EInvoiceType> INVOICE_TYPE__COMMENT_PRINT;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EInvoiceType lookup(@NonNull String candidate, @NonNull EInvoiceType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EInvoiceType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EInvoiceType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EInvoiceType.key((String)candidate);
        return Optional.ofNullable((EInvoiceType)LOOKUP.get(key));
    }

    @NonNull
    public static EInvoiceType lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional measurementViewTypeCandidate = EInvoiceType.lookup((String)candidate);
        if (measurementViewTypeCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.INVOICE__INVOICE_TYPE), (String)candidate, EInvoiceType.class, EInvoiceType::allowedKeys);
        }
        return (EInvoiceType)measurementViewTypeCandidate.get();
    }

    @Nonnull
    private static String key(@NonNull EInvoiceType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EInvoiceType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.invoice_type." + EInvoiceType.key((EInvoiceType)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EInvoiceType value : EInvoiceType.values()) {
            String key = EInvoiceType.key((EInvoiceType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        INVOICE_TYPES_FOR_SECONDARY_INVOICES = ImmutableSet.of((Object)PARTIAL_INVOICE, (Object)PARTIAL_FINAL_INVOICE, (Object)FINAL_INVOICE, (Object)INVOICE);
        INVOICE_TYPES__UNCLOSE_ON_CANCELLATION = ImmutableSet.of((Object)PARTIAL_FINAL_INVOICE, (Object)FINAL_INVOICE);
        INVOICE_TYPES__VOUCHER_SUM_ON_INVOICE_PRINT = ImmutableSet.of((Object)CREDIT_VOUCHER);
        INVOICE_TYPE__COMMENT_PRINT = ImmutableSet.of((Object)INVOICE);
    }
}

