/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.employee.payroll;

import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;

@Entity(name="WageAccountTransaction")
@Table(name="WAGE_ACCOUNT_TRANSACTION")
public class WageAccountTransaction
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="WAGE_ACCOUNT_TRANSACTION_SEQ")
    @SequenceGenerator(sequenceName="WAGE_ACCOUNT_TRANSACTION_SEQ", allocationSize=1, name="WAGE_ACCOUNT_TRANSACTION_SEQ")
    private Long id;
    @Column(name="amount")
    private BigDecimal amount;
    @Column(name="original_amount")
    private BigDecimal originalAmount;
    @Column(name="balance_old")
    private BigDecimal balanceOld;
    @Column(name="balance_new")
    private BigDecimal balanceNew;
    @OneToOne(mappedBy="wageAccountTransaction")
    private PayrollMonthItem payrollMonthItem;
    @JoinColumn(name="original_stage_id")
    @ManyToOne
    private Quotation originalStage;
    @JoinColumn(name="sender_user_id")
    @ManyToOne
    private User sender;
    @JoinColumn(name="recipient_user_id")
    @ManyToOne
    private User recipient;
    @JoinColumn(name="wage_account_id")
    @ManyToOne(optional=true)
    private WageAccount wageAccount;
    @JoinColumn(name="wage_account_original_id")
    @ManyToOne(optional=true)
    private WageAccount wageAccountOriginal;

    public Long getId() {
        return this.id;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public BigDecimal getBalanceOld() {
        return this.balanceOld;
    }

    public BigDecimal getBalanceNew() {
        return this.balanceNew;
    }

    public PayrollMonthItem getPayrollMonthItem() {
        return this.payrollMonthItem;
    }

    public Quotation getOriginalStage() {
        return this.originalStage;
    }

    public User getSender() {
        return this.sender;
    }

    public User getRecipient() {
        return this.recipient;
    }

    public WageAccount getWageAccount() {
        return this.wageAccount;
    }

    public WageAccount getWageAccountOriginal() {
        return this.wageAccountOriginal;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    public void setBalanceOld(BigDecimal balanceOld) {
        this.balanceOld = balanceOld;
    }

    public void setBalanceNew(BigDecimal balanceNew) {
        this.balanceNew = balanceNew;
    }

    public void setPayrollMonthItem(PayrollMonthItem payrollMonthItem) {
        this.payrollMonthItem = payrollMonthItem;
    }

    public void setOriginalStage(Quotation originalStage) {
        this.originalStage = originalStage;
    }

    public void setSender(User sender) {
        this.sender = sender;
    }

    public void setRecipient(User recipient) {
        this.recipient = recipient;
    }

    public void setWageAccount(WageAccount wageAccount) {
        this.wageAccount = wageAccount;
    }

    public void setWageAccountOriginal(WageAccount wageAccountOriginal) {
        this.wageAccountOriginal = wageAccountOriginal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WageAccountTransaction)) {
            return false;
        }
        WageAccountTransaction other = (WageAccountTransaction)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        BigDecimal this$originalAmount = this.getOriginalAmount();
        BigDecimal other$originalAmount = other.getOriginalAmount();
        if (this$originalAmount == null ? other$originalAmount != null : !((Object)this$originalAmount).equals(other$originalAmount)) {
            return false;
        }
        BigDecimal this$balanceOld = this.getBalanceOld();
        BigDecimal other$balanceOld = other.getBalanceOld();
        if (this$balanceOld == null ? other$balanceOld != null : !((Object)this$balanceOld).equals(other$balanceOld)) {
            return false;
        }
        BigDecimal this$balanceNew = this.getBalanceNew();
        BigDecimal other$balanceNew = other.getBalanceNew();
        return !(this$balanceNew == null ? other$balanceNew != null : !((Object)this$balanceNew).equals(other$balanceNew));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WageAccountTransaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        BigDecimal $originalAmount = this.getOriginalAmount();
        result = result * 59 + ($originalAmount == null ? 43 : ((Object)$originalAmount).hashCode());
        BigDecimal $balanceOld = this.getBalanceOld();
        result = result * 59 + ($balanceOld == null ? 43 : ((Object)$balanceOld).hashCode());
        BigDecimal $balanceNew = this.getBalanceNew();
        result = result * 59 + ($balanceNew == null ? 43 : ((Object)$balanceNew).hashCode());
        return result;
    }

    public String toString() {
        return "WageAccountTransaction(super=" + super.toString() + ", id=" + this.getId() + ", amount=" + String.valueOf(this.getAmount()) + ", originalAmount=" + String.valueOf(this.getOriginalAmount()) + ", balanceOld=" + String.valueOf(this.getBalanceOld()) + ", balanceNew=" + String.valueOf(this.getBalanceNew()) + ")";
    }
}

