/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.employee.payroll;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EPayrollItemUnit implements Translatable
{
    UNKNOWN,
    VALUE,
    HOUR,
    DAY;

    private static final Map<String, EPayrollItemUnit> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EPayrollItemUnit lookup(@NonNull String candidate, @NonNull EPayrollItemUnit defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EPayrollItemUnit.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EPayrollItemUnit> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EPayrollItemUnit.key((String)candidate);
        return Optional.ofNullable((EPayrollItemUnit)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EPayrollItemUnit item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EPayrollItemUnit.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @NonNull
    public static EPayrollItemUnit lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EPayrollItemUnit.key((String)candidate);
        EPayrollItemUnit payrollItemUnit = (EPayrollItemUnit)LOOKUP.get(key);
        if (null == payrollItemUnit) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_ITEM_TYPE__UNIT), (String)candidate, EPayrollItemUnit.class, EPayrollItemUnit::allowedKeys);
        }
        return payrollItemUnit;
    }

    @Nonnull
    public String messageCode() {
        return "enum.payroll_item_unit." + EPayrollItemUnit.key((EPayrollItemUnit)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EPayrollItemUnit value : EPayrollItemUnit.values()) {
            String key = EPayrollItemUnit.key((EPayrollItemUnit)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

