/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.employee.contract;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContractConfig;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.generic.EFederalState;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Hibernate;

@Entity(name="LaborUnionContract")
@Table(name="LABOR_UNION_CONTRACT")
public class LaborUnionContract
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="LABOR_UNION_CONTRACT_SEQ")
    @SequenceGenerator(sequenceName="LABOR_UNION_CONTRACT_SEQ", allocationSize=1, name="LABOR_UNION_CONTRACT_SEQ")
    private Long id;
    @Column(name="reference_id", length=50)
    private String referenceId;
    @Column(name="name", length=50)
    @Convert(converter=NullStringConverter.class)
    private String name;
    @Column(name="description", length=250)
    @Convert(converter=NullStringConverter.class)
    private String description;
    @Enumerated(value=EnumType.STRING)
    @Column(name="federal_state", length=250)
    private EFederalState federalState;
    @Column(name="flag_bad_weather_logging")
    private Boolean flagBadWeatherLogging;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="laborUnionContract", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<LaborUnionContractConfig> configs;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="laborUnionContract", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<LaborUnionWageGroup> wageGroups;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="laborUnionContract", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<PayrollItemType> payrollItemTypes;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        LaborUnionContract that = (LaborUnionContract)o;
        return this.id != null && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EFederalState getFederalState() {
        return this.federalState;
    }

    public Boolean getFlagBadWeatherLogging() {
        return this.flagBadWeatherLogging;
    }

    public Set<LaborUnionContractConfig> getConfigs() {
        return this.configs;
    }

    public Set<LaborUnionWageGroup> getWageGroups() {
        return this.wageGroups;
    }

    public Set<PayrollItemType> getPayrollItemTypes() {
        return this.payrollItemTypes;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFederalState(EFederalState federalState) {
        this.federalState = federalState;
    }

    public void setFlagBadWeatherLogging(Boolean flagBadWeatherLogging) {
        this.flagBadWeatherLogging = flagBadWeatherLogging;
    }

    public void setConfigs(Set<LaborUnionContractConfig> configs) {
        this.configs = configs;
    }

    public void setWageGroups(Set<LaborUnionWageGroup> wageGroups) {
        this.wageGroups = wageGroups;
    }

    public void setPayrollItemTypes(Set<PayrollItemType> payrollItemTypes) {
        this.payrollItemTypes = payrollItemTypes;
    }

    public String toString() {
        return "LaborUnionContract(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", federalState=" + String.valueOf(this.getFederalState()) + ", flagBadWeatherLogging=" + this.getFlagBadWeatherLogging() + ")";
    }
}

