/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.employee.attendance;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EAttendanceDayType implements Translatable
{
    UNKNOWN,
    NONE,
    STANDARD,
    VACATION,
    SICK,
    CHILD_SICK_LEAVE,
    ABSENT,
    PARENTAL_LEAVE,
    BAD_WEATHER,
    BAD_WEATHER_SICK,
    ON_DUTY;

    public static final Map<EAttendanceDayType, String> ABBREVIATION;
    private static final Map<String, EAttendanceDayType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EAttendanceDayType lookup(@NonNull String candidate, @NonNull EAttendanceDayType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EAttendanceDayType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EAttendanceDayType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EAttendanceDayType.key((String)candidate);
        return Optional.ofNullable((EAttendanceDayType)LOOKUP.get(key));
    }

    @NonNull
    public static EAttendanceDayType lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EAttendanceDayType.key((String)candidate);
        EAttendanceDayType attendanceDayType = (EAttendanceDayType)LOOKUP.get(key);
        if (null == attendanceDayType) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__ATTENDANCE__ATTENDANCE_DAY_TYPE), (String)candidate, EAttendanceDayType.class, EAttendanceDayType::allowedKeys);
        }
        return attendanceDayType;
    }

    @Nonnull
    private static String key(@NonNull EAttendanceDayType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EAttendanceDayType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.employee_day_type." + StringUtils.lowerCase((String)this.name());
    }

    @Nonnull
    public String abbreviation() {
        return ABBREVIATION.getOrDefault(this, "");
    }

    static {
        ABBREVIATION = ImmutableMap.builder().put((Object)UNKNOWN, (Object)"").put((Object)NONE, (Object)"").put((Object)STANDARD, (Object)"A").put((Object)VACATION, (Object)"U").put((Object)SICK, (Object)"K").put((Object)CHILD_SICK_LEAVE, (Object)"KK").put((Object)ABSENT, (Object)"F").put((Object)PARENTAL_LEAVE, (Object)"EZ").put((Object)BAD_WEATHER, (Object)"SW").put((Object)BAD_WEATHER_SICK, (Object)"SWK").put((Object)ON_DUTY, (Object)"RB").build();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EAttendanceDayType value : EAttendanceDayType.values()) {
            String key = EAttendanceDayType.key((EAttendanceDayType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

