/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.customer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ECustomerState implements Translatable
{
    UNKNOWN,
    TEMPORARY,
    ACTIVE,
    ARCHIVED;

    private static final Map<String, ECustomerState> LOOKUP;
    @Nonnull
    public static final Iterable<ECustomerState> ALL_VALID;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static ECustomerState lookup(@NonNull String candidate, @NonNull ECustomerState defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return ECustomerState.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<ECustomerState> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = ECustomerState.key((String)candidate);
        return Optional.ofNullable((ECustomerState)LOOKUP.get(key));
    }

    @NonNull
    public static ECustomerState lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional measurementViewTypeCandidate = ECustomerState.lookup((String)candidate);
        if (measurementViewTypeCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.INVOICE__INVOICE_TYPE), (String)candidate, ECustomerState.class, ECustomerState::allowedKeys);
        }
        return (ECustomerState)measurementViewTypeCandidate.get();
    }

    @Nonnull
    private static String key(@NonNull ECustomerState item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return ECustomerState.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.customer_state." + ECustomerState.key((ECustomerState)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ECustomerState value : ECustomerState.values()) {
            String key = ECustomerState.key((ECustomerState)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        ALL_VALID = ImmutableSet.of((Object)TEMPORARY, (Object)ACTIVE);
    }
}

