/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.businessunit;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.model.jpa.user.User;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDate;

@Entity(name="UserBusinessUnit")
@Table(name="USER_BUSINESS_UNIT")
public class UserBusinessUnit
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_BUSINESS_UNIT_SEQ")
    @SequenceGenerator(sequenceName="USER_BUSINESS_UNIT_SEQ", allocationSize=1, name="USER_BUSINESS_UNIT_SEQ")
    private Long id;
    @Column(name="VALID_BEGIN")
    private LocalDate validBegin;
    @Column(name="VALID_END")
    private LocalDate validEnd;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="business_unit_id")
    private BusinessUnit businessUnit;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks", length=250)
    private String remarks;
    @Column(name="flag_lead")
    private Boolean flagLead;
    @Column(name="percent")
    private Integer percent;

    public Long getId() {
        return this.id;
    }

    public LocalDate getValidBegin() {
        return this.validBegin;
    }

    public LocalDate getValidEnd() {
        return this.validEnd;
    }

    public User getUser() {
        return this.user;
    }

    public BusinessUnit getBusinessUnit() {
        return this.businessUnit;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public Boolean getFlagLead() {
        return this.flagLead;
    }

    public Integer getPercent() {
        return this.percent;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setValidBegin(LocalDate validBegin) {
        this.validBegin = validBegin;
    }

    public void setValidEnd(LocalDate validEnd) {
        this.validEnd = validEnd;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setBusinessUnit(BusinessUnit businessUnit) {
        this.businessUnit = businessUnit;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setFlagLead(Boolean flagLead) {
        this.flagLead = flagLead;
    }

    public void setPercent(Integer percent) {
        this.percent = percent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserBusinessUnit)) {
            return false;
        }
        UserBusinessUnit other = (UserBusinessUnit)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$flagLead = this.getFlagLead();
        Boolean other$flagLead = other.getFlagLead();
        if (this$flagLead == null ? other$flagLead != null : !((Object)this$flagLead).equals(other$flagLead)) {
            return false;
        }
        Integer this$percent = this.getPercent();
        Integer other$percent = other.getPercent();
        if (this$percent == null ? other$percent != null : !((Object)this$percent).equals(other$percent)) {
            return false;
        }
        LocalDate this$validBegin = this.getValidBegin();
        LocalDate other$validBegin = other.getValidBegin();
        if (this$validBegin == null ? other$validBegin != null : !((Object)this$validBegin).equals(other$validBegin)) {
            return false;
        }
        LocalDate this$validEnd = this.getValidEnd();
        LocalDate other$validEnd = other.getValidEnd();
        if (this$validEnd == null ? other$validEnd != null : !((Object)this$validEnd).equals(other$validEnd)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        return !(this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserBusinessUnit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $flagLead = this.getFlagLead();
        result = result * 59 + ($flagLead == null ? 43 : ((Object)$flagLead).hashCode());
        Integer $percent = this.getPercent();
        result = result * 59 + ($percent == null ? 43 : ((Object)$percent).hashCode());
        LocalDate $validBegin = this.getValidBegin();
        result = result * 59 + ($validBegin == null ? 43 : ((Object)$validBegin).hashCode());
        LocalDate $validEnd = this.getValidEnd();
        result = result * 59 + ($validEnd == null ? 43 : ((Object)$validEnd).hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        return result;
    }

    public String toString() {
        return "UserBusinessUnit(super=" + super.toString() + ", id=" + this.getId() + ", validBegin=" + String.valueOf(this.getValidBegin()) + ", validEnd=" + String.valueOf(this.getValidEnd()) + ", remarks=" + this.getRemarks() + ", flagLead=" + this.getFlagLead() + ", percent=" + this.getPercent() + ")";
    }
}

