/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.user;

import de.qfm.erp.service.model.internal.user.AutoCompleteUser;
import lombok.NonNull;

public class AutoCompleteBucket<T extends AutoCompleteUser> {
    @NonNull
    private final T user;
    private final boolean disabled;

    private AutoCompleteBucket(@NonNull T user, boolean disabled) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.user = user;
        this.disabled = disabled;
    }

    public static <T extends AutoCompleteUser> AutoCompleteBucket<T> of(@NonNull T user, boolean disabled) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return new AutoCompleteBucket(user, disabled);
    }

    @NonNull
    public T getUser() {
        return (T)this.user;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoCompleteBucket)) {
            return false;
        }
        AutoCompleteBucket other = (AutoCompleteBucket)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        AutoCompleteUser this$user = this.getUser();
        AutoCompleteUser other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoCompleteBucket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        AutoCompleteUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "AutoCompleteBucket(user=" + String.valueOf(this.getUser()) + ", disabled=" + this.isDisabled() + ")";
    }
}

