/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.transposition;

import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.Nullable;
import lombok.NonNull;

public class Cell {
    @NonNull
    private String columnId;
    @Nullable
    private BigDecimal amount;
    @NotNull
    private Integer sequenceNumberMeasurementStandard;
    @NotNull
    private Integer sequenceNumberMeasurementTransposed;
    @NotNull
    private LocalDate accountingMonth;
    @NonNull
    private Iterable<Long> measurementPositionIds;

    private Cell(@NonNull String columnId, @Nullable BigDecimal amount, Integer sequenceNumberMeasurementStandard, Integer sequenceNumberMeasurementTransposed, LocalDate accountingMonth, @NonNull Iterable<Long> measurementPositionIds) {
        if (columnId == null) {
            throw new NullPointerException("columnId is marked non-null but is null");
        }
        if (measurementPositionIds == null) {
            throw new NullPointerException("measurementPositionIds is marked non-null but is null");
        }
        this.columnId = columnId;
        this.amount = amount;
        this.sequenceNumberMeasurementStandard = sequenceNumberMeasurementStandard;
        this.sequenceNumberMeasurementTransposed = sequenceNumberMeasurementTransposed;
        this.accountingMonth = accountingMonth;
        this.measurementPositionIds = measurementPositionIds;
    }

    public static Cell of(@NonNull String columnId, @Nullable BigDecimal amount, Integer sequenceNumberMeasurementStandard, Integer sequenceNumberMeasurementTransposed, LocalDate accountingMonth, @NonNull Iterable<Long> measurementPositionIds) {
        if (columnId == null) {
            throw new NullPointerException("columnId is marked non-null but is null");
        }
        if (measurementPositionIds == null) {
            throw new NullPointerException("measurementPositionIds is marked non-null but is null");
        }
        return new Cell(columnId, amount, sequenceNumberMeasurementStandard, sequenceNumberMeasurementTransposed, accountingMonth, measurementPositionIds);
    }

    public Cell() {
    }

    @NonNull
    public String getColumnId() {
        return this.columnId;
    }

    @Nullable
    public BigDecimal getAmount() {
        return this.amount;
    }

    public Integer getSequenceNumberMeasurementStandard() {
        return this.sequenceNumberMeasurementStandard;
    }

    public Integer getSequenceNumberMeasurementTransposed() {
        return this.sequenceNumberMeasurementTransposed;
    }

    public LocalDate getAccountingMonth() {
        return this.accountingMonth;
    }

    @NonNull
    public Iterable<Long> getMeasurementPositionIds() {
        return this.measurementPositionIds;
    }

    public String toString() {
        return "Cell(columnId=" + this.getColumnId() + ", amount=" + String.valueOf(this.getAmount()) + ", sequenceNumberMeasurementStandard=" + this.getSequenceNumberMeasurementStandard() + ", sequenceNumberMeasurementTransposed=" + this.getSequenceNumberMeasurementTransposed() + ", accountingMonth=" + String.valueOf(this.getAccountingMonth()) + ", measurementPositionIds=" + String.valueOf(this.getMeasurementPositionIds()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$sequenceNumberMeasurementStandard = this.getSequenceNumberMeasurementStandard();
        Integer other$sequenceNumberMeasurementStandard = other.getSequenceNumberMeasurementStandard();
        if (this$sequenceNumberMeasurementStandard == null ? other$sequenceNumberMeasurementStandard != null : !((Object)this$sequenceNumberMeasurementStandard).equals(other$sequenceNumberMeasurementStandard)) {
            return false;
        }
        Integer this$sequenceNumberMeasurementTransposed = this.getSequenceNumberMeasurementTransposed();
        Integer other$sequenceNumberMeasurementTransposed = other.getSequenceNumberMeasurementTransposed();
        if (this$sequenceNumberMeasurementTransposed == null ? other$sequenceNumberMeasurementTransposed != null : !((Object)this$sequenceNumberMeasurementTransposed).equals(other$sequenceNumberMeasurementTransposed)) {
            return false;
        }
        String this$columnId = this.getColumnId();
        String other$columnId = other.getColumnId();
        if (this$columnId == null ? other$columnId != null : !this$columnId.equals(other$columnId)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        LocalDate this$accountingMonth = this.getAccountingMonth();
        LocalDate other$accountingMonth = other.getAccountingMonth();
        if (this$accountingMonth == null ? other$accountingMonth != null : !((Object)this$accountingMonth).equals(other$accountingMonth)) {
            return false;
        }
        Iterable this$measurementPositionIds = this.getMeasurementPositionIds();
        Iterable other$measurementPositionIds = other.getMeasurementPositionIds();
        return !(this$measurementPositionIds == null ? other$measurementPositionIds != null : !this$measurementPositionIds.equals(other$measurementPositionIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cell;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sequenceNumberMeasurementStandard = this.getSequenceNumberMeasurementStandard();
        result = result * 59 + ($sequenceNumberMeasurementStandard == null ? 43 : ((Object)$sequenceNumberMeasurementStandard).hashCode());
        Integer $sequenceNumberMeasurementTransposed = this.getSequenceNumberMeasurementTransposed();
        result = result * 59 + ($sequenceNumberMeasurementTransposed == null ? 43 : ((Object)$sequenceNumberMeasurementTransposed).hashCode());
        String $columnId = this.getColumnId();
        result = result * 59 + ($columnId == null ? 43 : $columnId.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        LocalDate $accountingMonth = this.getAccountingMonth();
        result = result * 59 + ($accountingMonth == null ? 43 : ((Object)$accountingMonth).hashCode());
        Iterable $measurementPositionIds = this.getMeasurementPositionIds();
        result = result * 59 + ($measurementPositionIds == null ? 43 : $measurementPositionIds.hashCode());
        return result;
    }
}

