/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.search;

import com.google.common.collect.Range;
import de.qfm.erp.service.model.search.IndexField;
import lombok.NonNull;

public class Highlight {
    @NonNull
    private IndexField field;
    @NonNull
    private String original;
    @NonNull
    private Range<Integer> range;

    private Highlight(@NonNull IndexField field, @NonNull String original, @NonNull Range<Integer> range) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        this.field = field;
        this.original = original;
        this.range = range;
    }

    public static Highlight of(@NonNull IndexField field, @NonNull String original, @NonNull Range<Integer> range) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        return new Highlight(field, original, range);
    }

    private Highlight() {
    }

    @NonNull
    public IndexField getField() {
        return this.field;
    }

    @NonNull
    public String getOriginal() {
        return this.original;
    }

    @NonNull
    public Range<Integer> getRange() {
        return this.range;
    }

    public String toString() {
        return "Highlight(field=" + String.valueOf(this.getField()) + ", original=" + this.getOriginal() + ", range=" + String.valueOf(this.getRange()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Highlight)) {
            return false;
        }
        Highlight other = (Highlight)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IndexField this$field = this.getField();
        IndexField other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$original = this.getOriginal();
        String other$original = other.getOriginal();
        if (this$original == null ? other$original != null : !this$original.equals(other$original)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        return !(this$range == null ? other$range != null : !this$range.equals(other$range));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Highlight;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IndexField $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $original = this.getOriginal();
        result = result * 59 + ($original == null ? 43 : $original.hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : $range.hashCode());
        return result;
    }
}

