/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.pdfbox;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EBooleanPrintOption {
    PRINT_INTERNAL_WAGE_ENABLED("option_print_internal_wage", false),
    PRINT_SQUAD_ENABLED("option_print_squad", true),
    PRINT_OVERALL_VALUE_ENABLED("option_print_overall_value", false),
    FILL_UP_TABLE_ENABLED("option_fillup_table", false),
    PRINT_HEADER_REMARKS_ENABLED("option_print_header_remarks", false),
    PRINT_MEASUREMENT_TYPE_ENABLED("option_print_header_measurement_type", false),
    FREE_FROM_DEFECTS_CHECKED("option_free_from_defects_checked", false),
    WORK_IS_ACCEPTED_CHECKED("option_work_is_accepted_checked", false),
    TRANSFER_OF_PERIL_CHECKED("option_transfer_of_peril_checked", false),
    PRINT_JUMBO_A("option_print_jumbo_a", true),
    PRINT_JUMBO_B("option_print_jumbo_b", true);

    @NonNull
    private final String parameter;
    private final boolean defaultValue;
    private static final Map<String, EBooleanPrintOption> LOOKUP;

    private EBooleanPrintOption(String parameter, boolean defaultValue) {
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        this.parameter = parameter;
        this.defaultValue = defaultValue;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EBooleanPrintOption lookup(@NonNull String candidate, @NonNull EBooleanPrintOption defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EBooleanPrintOption.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EBooleanPrintOption> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EBooleanPrintOption.key((String)candidate);
        return Optional.ofNullable((EBooleanPrintOption)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EBooleanPrintOption printOption) {
        if (printOption == null) {
            throw new NullPointerException("printOption is marked non-null but is null");
        }
        return EBooleanPrintOption.key((String)printOption.getParameter());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @NonNull
    public String getParameter() {
        return this.parameter;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EBooleanPrintOption value : EBooleanPrintOption.values()) {
            String key = EBooleanPrintOption.key((EBooleanPrintOption)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

