/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.payroll;

import com.google.common.collect.Multimap;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import lombok.NonNull;

public class PayrollMonthCalculationBucket {
    @NonNull
    private final PayrollMonth payrollMonth;
    @NonNull
    private final PayrollItemType payrollItemType;
    @NonNull
    private final Multimap<PayrollItemType, PayrollMonthItem> payrollMonthItemsByPayrollItemType;
    @NonNull
    private final Iterable<Attendance> squadLeaderAttendances;
    @NonNull
    private final Iterable<PayrollMonthItem> incentivePayrollMonthItems;

    private PayrollMonthCalculationBucket(@NonNull PayrollMonth payrollMonth, @NonNull PayrollItemType payrollItemType, @NonNull Multimap<PayrollItemType, PayrollMonthItem> payrollMonthItemsByPayrollItemType, @NonNull Iterable<Attendance> squadLeaderAttendances, @NonNull Iterable<PayrollMonthItem> incentivePayrollMonthItems) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        if (payrollMonthItemsByPayrollItemType == null) {
            throw new NullPointerException("payrollMonthItemsByPayrollItemType is marked non-null but is null");
        }
        if (squadLeaderAttendances == null) {
            throw new NullPointerException("squadLeaderAttendances is marked non-null but is null");
        }
        if (incentivePayrollMonthItems == null) {
            throw new NullPointerException("incentivePayrollMonthItems is marked non-null but is null");
        }
        this.payrollMonth = payrollMonth;
        this.payrollItemType = payrollItemType;
        this.payrollMonthItemsByPayrollItemType = payrollMonthItemsByPayrollItemType;
        this.squadLeaderAttendances = squadLeaderAttendances;
        this.incentivePayrollMonthItems = incentivePayrollMonthItems;
    }

    public static PayrollMonthCalculationBucket of(@NonNull PayrollMonth payrollMonth, @NonNull PayrollItemType payrollItemType, @NonNull Multimap<PayrollItemType, PayrollMonthItem> payrollMonthItemsByPayrollItemType, @NonNull Iterable<Attendance> squadLeaderAttendances, @NonNull Iterable<PayrollMonthItem> incentivePayrollMonthItems) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        if (payrollMonthItemsByPayrollItemType == null) {
            throw new NullPointerException("payrollMonthItemsByPayrollItemType is marked non-null but is null");
        }
        if (squadLeaderAttendances == null) {
            throw new NullPointerException("squadLeaderAttendances is marked non-null but is null");
        }
        if (incentivePayrollMonthItems == null) {
            throw new NullPointerException("incentivePayrollMonthItems is marked non-null but is null");
        }
        return new PayrollMonthCalculationBucket(payrollMonth, payrollItemType, payrollMonthItemsByPayrollItemType, squadLeaderAttendances, incentivePayrollMonthItems);
    }

    @NonNull
    public PayrollMonth getPayrollMonth() {
        return this.payrollMonth;
    }

    @NonNull
    public PayrollItemType getPayrollItemType() {
        return this.payrollItemType;
    }

    @NonNull
    public Multimap<PayrollItemType, PayrollMonthItem> getPayrollMonthItemsByPayrollItemType() {
        return this.payrollMonthItemsByPayrollItemType;
    }

    @NonNull
    public Iterable<Attendance> getSquadLeaderAttendances() {
        return this.squadLeaderAttendances;
    }

    @NonNull
    public Iterable<PayrollMonthItem> getIncentivePayrollMonthItems() {
        return this.incentivePayrollMonthItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayrollMonthCalculationBucket)) {
            return false;
        }
        PayrollMonthCalculationBucket other = (PayrollMonthCalculationBucket)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PayrollMonth this$payrollMonth = this.getPayrollMonth();
        PayrollMonth other$payrollMonth = other.getPayrollMonth();
        if (this$payrollMonth == null ? other$payrollMonth != null : !this$payrollMonth.equals(other$payrollMonth)) {
            return false;
        }
        PayrollItemType this$payrollItemType = this.getPayrollItemType();
        PayrollItemType other$payrollItemType = other.getPayrollItemType();
        if (this$payrollItemType == null ? other$payrollItemType != null : !this$payrollItemType.equals(other$payrollItemType)) {
            return false;
        }
        Multimap this$payrollMonthItemsByPayrollItemType = this.getPayrollMonthItemsByPayrollItemType();
        Multimap other$payrollMonthItemsByPayrollItemType = other.getPayrollMonthItemsByPayrollItemType();
        if (this$payrollMonthItemsByPayrollItemType == null ? other$payrollMonthItemsByPayrollItemType != null : !this$payrollMonthItemsByPayrollItemType.equals(other$payrollMonthItemsByPayrollItemType)) {
            return false;
        }
        Iterable this$squadLeaderAttendances = this.getSquadLeaderAttendances();
        Iterable other$squadLeaderAttendances = other.getSquadLeaderAttendances();
        if (this$squadLeaderAttendances == null ? other$squadLeaderAttendances != null : !this$squadLeaderAttendances.equals(other$squadLeaderAttendances)) {
            return false;
        }
        Iterable this$incentivePayrollMonthItems = this.getIncentivePayrollMonthItems();
        Iterable other$incentivePayrollMonthItems = other.getIncentivePayrollMonthItems();
        return !(this$incentivePayrollMonthItems == null ? other$incentivePayrollMonthItems != null : !this$incentivePayrollMonthItems.equals(other$incentivePayrollMonthItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PayrollMonthCalculationBucket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PayrollMonth $payrollMonth = this.getPayrollMonth();
        result = result * 59 + ($payrollMonth == null ? 43 : $payrollMonth.hashCode());
        PayrollItemType $payrollItemType = this.getPayrollItemType();
        result = result * 59 + ($payrollItemType == null ? 43 : $payrollItemType.hashCode());
        Multimap $payrollMonthItemsByPayrollItemType = this.getPayrollMonthItemsByPayrollItemType();
        result = result * 59 + ($payrollMonthItemsByPayrollItemType == null ? 43 : $payrollMonthItemsByPayrollItemType.hashCode());
        Iterable $squadLeaderAttendances = this.getSquadLeaderAttendances();
        result = result * 59 + ($squadLeaderAttendances == null ? 43 : $squadLeaderAttendances.hashCode());
        Iterable $incentivePayrollMonthItems = this.getIncentivePayrollMonthItems();
        result = result * 59 + ($incentivePayrollMonthItems == null ? 43 : $incentivePayrollMonthItems.hashCode());
        return result;
    }

    public String toString() {
        return "PayrollMonthCalculationBucket(payrollMonth=" + String.valueOf(this.getPayrollMonth()) + ", payrollItemType=" + String.valueOf(this.getPayrollItemType()) + ", payrollMonthItemsByPayrollItemType=" + String.valueOf(this.getPayrollMonthItemsByPayrollItemType()) + ", squadLeaderAttendances=" + String.valueOf(this.getSquadLeaderAttendances()) + ", incentivePayrollMonthItems=" + String.valueOf(this.getIncentivePayrollMonthItems()) + ")";
    }
}

