/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.payroll;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EPayrollPrintTemplate {
    UNKNOWN,
    ATTENDANCE,
    ATTENDANCES,
    PAYSLIP,
    REPORT,
    BAD_WEATHER_REPORT;

    private static final Map<String, EPayrollPrintTemplate> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EPayrollPrintTemplate lookup(@NonNull String candidate, @NonNull EPayrollPrintTemplate defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EPayrollPrintTemplate.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EPayrollPrintTemplate> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EPayrollPrintTemplate.key((String)candidate);
        return Optional.ofNullable((EPayrollPrintTemplate)LOOKUP.get(key));
    }

    @NonNull
    public static EPayrollPrintTemplate lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional candidateEnum = EPayrollPrintTemplate.lookup((String)candidate);
        if (candidateEnum.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PRINT_TEMPLATE), (String)candidate, EPayrollPrintTemplate.class, EPayrollPrintTemplate::allowedKeys);
        }
        return (EPayrollPrintTemplate)candidateEnum.get();
    }

    @Nonnull
    private static String key(@NonNull EPayrollPrintTemplate item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EPayrollPrintTemplate.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    public String toString() {
        return "EPayrollPrintTemplate." + this.name();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EPayrollPrintTemplate value : EPayrollPrintTemplate.values()) {
            String key = EPayrollPrintTemplate.key((EPayrollPrintTemplate)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

