/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.payroll;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EPayrollItemXlsTemplate implements Translatable
{
    UNKNOWN,
    SALES_REVENUE_CORRECTION,
    SALES_REVENUE_CORRECTION_DETAIL,
    SALES_REVENUE_CORRECTION_GROUPED;

    private static final Map<String, EPayrollItemXlsTemplate> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EPayrollItemXlsTemplate lookup(@NonNull String candidate, @NonNull EPayrollItemXlsTemplate defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EPayrollItemXlsTemplate.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EPayrollItemXlsTemplate> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EPayrollItemXlsTemplate.key((String)candidate);
        return Optional.ofNullable((EPayrollItemXlsTemplate)LOOKUP.get(key));
    }

    @NonNull
    public static EPayrollItemXlsTemplate lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional candidateEnum = EPayrollItemXlsTemplate.lookup((String)candidate);
        if (candidateEnum.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_ITEM_XLS_TEMPLATE), (String)candidate, EPayrollItemXlsTemplate.class, EPayrollItemXlsTemplate::allowedKeys);
        }
        return (EPayrollItemXlsTemplate)candidateEnum.get();
    }

    @Nonnull
    private static String key(@NonNull EPayrollItemXlsTemplate item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EPayrollItemXlsTemplate.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.payroll_item_xls_template." + EPayrollItemXlsTemplate.key((EPayrollItemXlsTemplate)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EPayrollItemXlsTemplate value : EPayrollItemXlsTemplate.values()) {
            String key = EPayrollItemXlsTemplate.key((EPayrollItemXlsTemplate)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

