/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.payroll;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EPayrollItemFilterOption implements Translatable
{
    SENDER_IN_BUSINESS_UNIT,
    RECIPIENT_IN_BUSINESS_UNIT,
    SENDER_IN_OR_RECIPIENT_IN_BUSINESS_UNIT,
    SENDER_IN_AND_RECIPIENT_IN_BUSINESS_UNIT,
    SENDER_IN_AND_RECIPIENT_NOT_IN_BUSINESS_UNIT,
    SENDER_NOT_IN_AND_RECIPIENT_IN_BUSINESS_UNIT,
    SENDER_IN_CHILD_BUSINESS_UNIT_AND_RECIPIENT_IN_UNEQUAL_CHILD_BUSINESS_UNIT;

    private static final Map<String, EPayrollItemFilterOption> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EPayrollItemFilterOption lookup(@NonNull String candidate, @NonNull EPayrollItemFilterOption defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EPayrollItemFilterOption.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EPayrollItemFilterOption> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EPayrollItemFilterOption.key((String)candidate);
        return Optional.ofNullable((EPayrollItemFilterOption)LOOKUP.get(key));
    }

    @NonNull
    public static EPayrollItemFilterOption lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional candidateEnum = EPayrollItemFilterOption.lookup((String)candidate);
        if (candidateEnum.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_ITEM_FILTER_OPTION), (String)candidate, EPayrollItemFilterOption.class, EPayrollItemFilterOption::allowedKeys);
        }
        return (EPayrollItemFilterOption)candidateEnum.get();
    }

    @Nonnull
    private static String key(@NonNull EPayrollItemFilterOption item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EPayrollItemFilterOption.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.payroll_item_type_filter_option." + EPayrollItemFilterOption.key((EPayrollItemFilterOption)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EPayrollItemFilterOption value : EPayrollItemFilterOption.values()) {
            String key = EPayrollItemFilterOption.key((EPayrollItemFilterOption)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

