/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.payroll;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EExportFileName implements Translatable
{
    UNKNOWN,
    PAYROLL_ATTENDANCE_PDF,
    PAYROLL_ATTENDANCE_BY_CC_PDF,
    PAYROLL_REPORT_PDF,
    PAYROLL_SLIP_PDF,
    PAYROLL_SLIPS_AS_PDF,
    PAYROLL_SLIPS_AS_ZIP,
    INVOICES_AS_ER2_NORMAL,
    INVOICES_AS_ER2_COMPANY_GROUP,
    INVOICES_AS_ZIP_ER2,
    INVOICES_AS_XLSX,
    INVOICES_AS_ZIP,
    INVOICE_AS_PDF,
    INVOICE_AS_XML,
    INVOICE_AS_ZIP,
    INVOICE_MEASUREMENT,
    MEASUREMENT_AS_XLSX,
    MEASUREMENT_AS_D11,
    MEASUREMENT_AS_X31,
    MEASUREMENT_AS_CSV,
    MEASUREMENT_AS_PDF,
    MEASUREMENT_PRELIMINARY_AS_PDF,
    PAYROLL_BAD_WEATHER_BY_CC_PDF,
    PAYROLL_BAD_WEATHER_PDF,
    PAYROLL_SLIP_ZIP,
    QSTAGE_AS_PDF,
    QSTAGE_AS_X84,
    QSTAGE_AS_XLSX,
    NAL_GROUPED_AS_XLSX,
    NAL_UNGROUPED_AS_XLSX,
    QUOTATION__BOQ_MEASUREMENT_TEMPLATE_AS_XLSX,
    PROJECT_BASED_WAGE_EXPORT_AS_XLSX,
    SALES_REVENUE_CORRECTION_DETAIL,
    SALES_REVENUE_CORRECTION_GROUPED,
    SALES_REVENUE_CORRECTION_XLS,
    SALES_REVENUE_CORRECTION_ZIP;

    private static final Map<String, EExportFileName> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EExportFileName lookup(@NonNull String candidate, @NonNull EExportFileName defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EExportFileName.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EExportFileName> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EExportFileName.key((String)candidate);
        return Optional.ofNullable((EExportFileName)LOOKUP.get(key));
    }

    @NonNull
    public static EExportFileName lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional candidateEnum = EExportFileName.lookup((String)candidate);
        if (candidateEnum.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_ITEM_XLS_TEMPLATE), (String)candidate, EExportFileName.class, EExportFileName::allowedKeys);
        }
        return (EExportFileName)candidateEnum.get();
    }

    @Nonnull
    private static String key(@NonNull EExportFileName item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EExportFileName.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.export.file.name." + EExportFileName.key((EExportFileName)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EExportFileName value : EExportFileName.values()) {
            String key = EExportFileName.key((EExportFileName)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

