/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.message;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.message.Translatable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EMessageKey implements Translatable
{
    UNKNOWN("error.unknown"),
    NOT_EMPTY("javax.not-empty"),
    NOT_NULL("javax.not-null"),
    SIZE("javax.size"),
    MIN("javax.min"),
    MAX("javax.max"),
    RANGE("javax.range"),
    DATE_RANGE("error.date-range"),
    FIELD_A_BEFORE_B("error.field-a-before-b"),
    FIELD_AND_REJECTED_VALUE("error.field-and-rejected-value"),
    ENUMERATION("error.enumeration"),
    ROW_VERSION("error.row-version"),
    ENTITY_NOT_FOUND("error.entity.not-found"),
    ENTITY_NOT_FOUND_GENERIC("error.entity.not-found-generic"),
    NO_CUSTOMER_TEMPLATE_ERROR("error.no-customer-template"),
    MULTIPLE_CUSTOMERS_ASSOCIATED_ERROR("error.multiple-customers-associated-with-the-selected-measurements"),
    MULTIPLE_STAGES_ASSOCIATED_ERROR("error.multiple-stages-associated-with-the-selected-measurements"),
    RULE_INVOICE__MEASUREMENTS_NOT_ACCOUNTABLE("rule.invoice.measurements.not_accountable"),
    RULE_INVOICE__MEASUREMENT_NOT_ACCOUNTABLE("rule.invoice.measurement.not_accountable"),
    RULE_INVOICE__MEASUREMENT_MORE_THAN_ONE_STAGE("rule.invoice.measurement.more-than-one-stage"),
    RULE_INVOICE__EXISTING_FINAL_INVOICE_IN_COST_UNIT("rule.invoice.existing-final-invoice-in-cost-unit"),
    RULE_INVOICE__MISSING_FINANCE_DATA("rule.invoice.missing-finance-data"),
    RULE_INVOICE__NO_VALID_STAGE_TYPE("rule.invoice.no-valid-stage-type"),
    RULE_INVOICE__NO_VALID_STAGE_STATE("rule.invoice.no-valid-stage-state"),
    RULE_MEASUREMENT_NUMBER_PREVENT_UPDATE("rule.measurement-number-prevent-update"),
    RULE_STAGE_NOT_USABLE_IN_MEASUREMENT("rule.stage-not-usable-in-measurement"),
    RULE_STAGE_POSITION_NOT_USABLE_IN_MEASUREMENT("rule.stage-position-not-usable-in-measurement"),
    RULE_RELEASE_ORDER__ORDER_NUMBER_MANDATORY("rule.release-order.order-number-mandatory"),
    RULE_MEASUREMENT_STATE_UPDATE_NOT_ALLOWED("rule.measurement.measurement-state-update-not-allowed"),
    RULE_MEASUREMENT_STATE_UPDATE_NOT_ALLOWED_MISSING_PRIVILEGE("rule.measurement.measurement-state-update-not-allowed-missing-privilege"),
    RULE_QUOTATION_ORDER_END("rule.measurement.quotation-order-end"),
    RULE_MEASUREMENT_STATE_CHANGE_MISSING_PRIVILEGE("rule.measurement-state-change-missing-privilege"),
    RULE_MEASUREMENT__STATE_TO_APPROVED_MISSING_PARTIAL_IN_APPROVED("rule.measurement-state-to-approved-missing-partial-in-approved"),
    RULE_PAYROLL_MONTH_UPDATE_NO_QUOTATION_NUMBER_AVAILABLE("rule.payroll-month-update-no-quotation-number-available"),
    RULE_PAYROLL_MONTH_AUXILIARY_WAGE_MISSING_REMARK("rule.payroll-month-update-auxiliary-wage-missing-remark"),
    RULE_PAYROLL_MONTH_AUXILIARY_WAGE_MISSING_PROJECT("rule.payroll-month-update-auxiliary-wage-missing-project"),
    RULE_PAYROLL_MONTH_AUXILIARY_WAGE_REMARK_NOT_IN_DICTIONARY("rule.payroll-month-update-auxiliary-wage-remark-not-in-dictionary"),
    RULE_PAYROLL_MONTH_UPDATE__INCENTIVE_WAGE__RECIPIENT_IN_RELEASED_STATE("rule.payroll-month-update-incentive-wage-recipient-in-released-state"),
    RULE_PAYROLL_MONTH_RESET__INCENTIVE_WAGE__RECIPIENT_IN_RELEASED_STATE("rule.payroll-month-reset-incentive-wage-recipient-in-released-state"),
    RULE_PAYROLL_MONTH_UPDATE__ATTENDANCE__SQUAD_LEADER_IN_RELEASED_STATE("rule.payroll-month-update-attendance-squad-leader-in-released-state"),
    RULE_PAYROLL_MONTH_RESET__ATTENDANCE__SQUAD_LEADER_IN_RELEASED_STATE("rule.payroll-month-reset-attendance-squad-leader-in-released-state"),
    RULE_PAYROLL_MONTH_STATE_CHANGE_MISSING_PRIVILEGE("rule.payroll-month-state-change-missing-privilege"),
    RULE_PAYROLL_MONTH_STATE_CHANGE_MISSING_PRIVILEGE__ALREADY_EXPORTED("rule.payroll-month-state-change-missing-privilege-already-exported"),
    RULE_PAYROLL_MONTH_STATE_CHANGE__SQUAD_LEADER_ALREADY_RELEASED("rule.payroll-month-state-change-squad-leader-already-released"),
    RULE_PAYROLL_MONTH_STATE_CHANGE__QUOTATION_WITH_NEGATIVE_WAGE("rule.payroll-month-state-change-quotation-with-negative-wage"),
    RULE_MEASUREMENT__PREVENT_DUPLICATE_CLOSING_MEASUREMENT_FOR_PSS_ID("rule.measurement-prevent-duplicate-closing-measurement-for-pss-id"),
    RULE_MEASUREMENT__PSS_RELEASE_ORDER_DISABLED("rule.measurement-pss-release-order-disabled"),
    RULE_ATTENDANCE_UPDATE_BAD_WEATHER_POST_EDIT("rule.attendance-update-bad-weather-post-edit"),
    RULE_ATTENDANCE_UPDATE_BAD_WEATHER_TOO_LATE("rule.attendance-update-bad-weather-too-late"),
    RULE_ATTENDANCE_UPDATE_PAYROLL_MONTH_RELEASED("rule.attendance-update-payroll-month-released"),
    RULE_ATTENDANCE_RESET_BAD_WEATHER_POST_EDIT("rule.attendance-reset-bad-weather-post-edit"),
    RULE_ATTENDANCE_RESET_PAYROLL_MONTH_RELEASED("rule.attendance-reset-payroll-month-released"),
    RULE_ATTENDANCE_RESET_BAD_WEATHER_TOO_LATE("rule.attendance-reset-bad-weather-too-late"),
    RULE_PAYROLL_MONTH__ATTENDANCE__BAD_WEATHER_NO_CONSTRUCTION_SITE("rule.payroll-month-attendance-badweather-no-constructionsite"),
    RULE_PAYROLL_MONTH__ATTENDANCE__BAD_WEATHER_NO_BAD_WEATHER_DURATION("rule.payroll-month-attendance-badweather-no-badweather-duration"),
    RULE_PAYROLL_MONTH__WAGE_ACCOUNT__BELOW_ZERO("rule.payroll-month-wage-account-below-zero"),
    RULE_PAYROLL_MONTH__WAGE_ACCOUNT__ABOVE_LIMIT("rule.payroll-month-wage-account-above-limit"),
    RULE_PAYROLL_MONTH__WAGE_ACCOUNT__ABOVE_AVAILABLE_IN_STAGE("rule.payroll-month-wage-account-above-available-in-stage"),
    RULE_MEASUREMENT_NOT_COMMISSIONED_POSITION_WARNING("rule.measurement-not-commissioned-position-warning"),
    RULE_MEASUREMENT_NOT_EXISTING_POSITION_WARNING("rule.measurement-not-existing-position-warning"),
    RULE_MEASUREMENT_NOT_DELETED_DUE_TO_STATE("rule.measurement-not-deleted-due-to-state"),
    RULE_MEASUREMENT_NOT_MOVED_DUE_TO_STATE("rule.measurement-not-moved-due-to-state"),
    RULE_STAGE__DUPLICATE_ADDENDUM_NUMBER("rule.stage-duplicate-addendum-number"),
    RULE_STAGE__POSITION__CHANGE_IN_QUANTITY__ERROR("rule.stage-position-change-in-amount-error"),
    RULE_STAGE__POSITION__CHANGE_IN_QUANTITY__IS_NOT_EQUAL("rule.stage-position-change-in-amount-is-not-equal"),
    RULE_STAGE__POSITION__CHANGE_IN_QUANTITY__NOT_EXISTING("rule.stage-position-change-in-amount-not-existing"),
    RULE_STAGE_ARCHIVE__NOT_ACCOUNTED_MEASUREMENT("rule.stage-archive.not-accounted-measurement"),
    RULE_STAGE_ARCHIVE__UNPAID_SQUAD_WAGE("rule.stage-archive.unpaid-squad-wage"),
    RULE_STAGE_ARCHIVE__NOT_ACCOUNTED_INVOICE("rule.stage-archive.not-accounted-invoice"),
    RULE_STAGE_ARCHIVE__PARTIAL_WITHOUT_FINAL_INVOICE("rule.stage-archive.partial-without-final-invoice"),
    RULE_STAGE_ARCHIVE__INVOICE_TOO_YOUNG("rule.stage-archive.invoice-too-young"),
    RULE_STAGE_ARCHIVE__FOUND_OTHER_VERSIONS("rule.stage-archive.found-other-versions"),
    RULE_STAGE_ARCHIVE__COMMISSION_NOT_PRIMARY("rule.stage-archive.commission-not-primary"),
    RULE_STAGE_ARCHIVE__VALIDATION_ERROR("rule.stage-archive.validation-error"),
    RULE_STAGE__STATE_IS_DESIGNATED_COMMISSION("rule.stage-state.designated-commission"),
    RULE_STAGE__STATE_IS_COMMISSIONED("rule.stage-state.commissioned"),
    RULE_ENTITY__SUBPROJECT__DUPLICATE_NAME("rule.entity.subproject.duplicate-name"),
    SECURITY__GENERIC_ENTITY_ACCESS_RESTRICTION("security.entity.access.restriction"),
    SECURITY__MEASUREMENT_ACCESS_RESTRICTION("security.measurement.access.restriction"),
    SECURITY__USER_PASSWORD_CHANGE__DO_NOT_MATCH("security.user.password.do-not-match"),
    SECURITY__USER_PASSWORD_CHANGE__NOT_ALLOWED("security.user.password.not-allowed"),
    SECURITY__USER_DISABLE__MISSING_PRIVILEGE("security.user.disable.missing-privilege"),
    SECURITY__INVOICE_READ__NOT_ALLOWED("security.invoice.read.not-allowed"),
    SECURITY__INVOICE_WRITE__NOT_ALLOWED("security.invoice.write.not-allowed"),
    SECURITY__QSTAGE_READ__NOT_ALLOWED("security.qstage.read.not-allowed"),
    SECURITY__QSTAGE_WRITE__NOT_ALLOWED("security.qstage.write.not-allowed"),
    SECURITY__QSTAGE__INDIVIDUAL_PROJECT__MISSING_PRIVILEGE("security.qstage.individual-project.missing-privilege"),
    NO_BCRYPT_PATTERN_FOUND("error.no-crypt-pattern-found"),
    NO_SHA256_PATTERN_FOUND("error.no-sha256-pattern-found"),
    DUPLICATE_SQUAD_REFERENCE_ID("error.duplicate-squad-reference-id"),
    DUPLICATE_USER_REFERENCE_ID("error.duplicate-user-reference-id"),
    DUPLICATE_PSS_RELEASE_ORDER_REFERENCE_ID("error.duplicate-pss-release-order-reference-id"),
    DUPLICATE_MEASUREMENT_REFERENCE_ID("error.duplicate-measurement-reference-id"),
    DUPLICATE_MEASUREMENT_POSITION__SEQUENTIAL_NUMBER("error.duplicate-measurement-position-sequential-number"),
    DUPLICATE_QUOTATION_REFERENCE_ID("error.duplicate-quotation-reference-id"),
    DUPLICATE_RELEASE_ORDER_REFERENCE_ID("error.duplicate-release-order-reference-id"),
    DUPLICATE_QUOTATION_ADDENDUM_NUMBER("error.duplicate-quotation-addendum-number"),
    DUPLICATE_TAX_KEY__VAT_INVOICE_TYPE("error.duplicate-tax-key-vat-and-invoice-type"),
    DUPLICATE_REQUEST_QUOTATION_POSITIONS_REFERENCE_ID("error.duplicate-quotation-position-reference-id"),
    DUPLICATE_REQUEST_QUOTATION_POSITIONS_POSITION_NUMBER("error.duplicate-quotation-position-number"),
    DUPLICATE_REQUEST_QUOTATION_POSITIONS_POSITION_NUMBER_MISSING("error.duplicate-quotation-position-number-missing"),
    DUPLICATION_MEASUREMENT_NUMBER_PRESENT("error.duplication-measurement-number-present"),
    DUPLICATE_USER_PERSONAL_NUMBER("error.duplicate-user-personal-number-present"),
    DUPLICATE_USER_USER_NAME("error.duplicate-user-user-name-present"),
    DUPLICATE_EMPLOYEE_CONTRACT_DATE_RANGE("error.duplicate-employee-contract-date-range"),
    DUPLICATE_USER_COST_CENTER__VALID_BEGIN("error.duplicate-user-cost-center-valid-begin"),
    DUPLICATE_EMPLOYEE_CONTRACT__VALID_BEGIN("error.duplicate-employee-contract-valid-begin"),
    DICTIONARY_ITEM_NAME__TOO_LONG_FOR_ENTITY("error.dictionary.item.name.too-long-for-entity-type"),
    TAX_KEY__DELETION_ERROR__USED_IN_INVOICES("error.taykey.deletion-error.used-in-invoices"),
    DUPLICATE_ROLE_NAME("error.duplicate-role-name-present"),
    BAD_REQUEST("request.bad-request"),
    MISSING_BUSINESS_UNIT_FOR_USER_AND_MONTH("error.missing.business-unit-for-user-and-month"),
    MISSING_LABOR_UNION_CONTRACT_FOR_USER_AND_MONTH("error.missing.labor-union-contract-for-user-and-month"),
    MISSING_LABOR_UNION_CONTRACT_CONFIG_FOR_CONTRACT_AND_MONTH("error.missing.labor-union-contract-config-for-contract-and-month"),
    MISSING_WAGE_GROUP_RATE_FOR_CONTRACT_AND_MONTH("error.missing.labor-union-wage-group-rate-for-contract-and-month"),
    MISSING_MEASUREMENT_NUMBER_FROM_SEQUENCE_MAX_TRIES("error.missing.measurement-number-from-sequence-max-tries"),
    USER_UPDATE__MISSING_LABOR_UNION_CONTRACT("error.missing.labor-union-contract-for-user"),
    USER_UPDATE__MISSING_LABOR_UNION_WAGE_GROUP("error.missing.labor-union-wage-group-for-user"),
    MEASUREMENT_COPY__MISSING_SPN("error.measurement.copy-missing-surrogate-position-number"),
    Q_ENTITY__MISSING_REFERENCE_IDS_IN_COMMISSION("error.stage.missing-reference-ids-in-commission"),
    STAGE__CONFLICT__CUSTOMER_AND_CONTACT_PERSON_DO_NOT_MATCH("error.stage.conflict-customer-and-contact-person-do-not-match"),
    INVOICE__UPLOAD_PDF_ERROR__TYPE_IS_DEBIT_NOTE("error.invoice.upload-pdf-error-type-is-debit-note"),
    INVOICE__UPLOAD_PDF_ERROR__TYPE_NOT_SUPPORTED("error.invoice.upload-pdf-error-type-not-supported"),
    INVOICE__UPLOAD_PDF_ERROR__NO_MEASUREMENT_FOUND("error.invoice.upload-pdf-error-no-measurement-found");

    private final String messageCode;
    private static final Map<String, EMessageKey> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EMessageKey lookup(@NonNull String candidate, @NonNull EMessageKey defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EMessageKey.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EMessageKey> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EMessageKey.key((String)candidate);
        return Optional.ofNullable((EMessageKey)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EMessageKey EMessageKey2) {
        if (EMessageKey2 == null) {
            throw new NullPointerException("EMessageKey is marked non-null but is null");
        }
        return EMessageKey.key((String)EMessageKey2.messageCode());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return this.messageCode;
    }

    private EMessageKey(String messageCode) {
        this.messageCode = messageCode;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public String toString() {
        return "EMessageKey." + this.name() + "(messageCode=" + this.getMessageCode() + ")";
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EMessageKey value : EMessageKey.values()) {
            String key = EMessageKey.key((EMessageKey)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

