/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.invoice;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EPdfExtractType implements Translatable
{
    NONE,
    TELEKOM,
    STROMNETZ_BERLIN,
    BVG;

    private static final Map<String, EPdfExtractType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EPdfExtractType lookup(@NonNull String candidate, @NonNull EPdfExtractType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EPdfExtractType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EPdfExtractType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EPdfExtractType.key((String)candidate);
        return Optional.ofNullable((EPdfExtractType)LOOKUP.get(key));
    }

    @NonNull
    public static EPdfExtractType lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional typeCandidate = EPdfExtractType.lookup((String)candidate);
        if (typeCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.QSTAGE__PDF_EXTRACT_TYPE), (String)candidate, EPdfExtractType.class, EPdfExtractType::allowedKeys);
        }
        return (EPdfExtractType)typeCandidate.get();
    }

    @Nonnull
    private static String key(@NonNull EPdfExtractType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EPdfExtractType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.pdf_extract_type." + EPdfExtractType.key((EPdfExtractType)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EPdfExtractType value : EPdfExtractType.values()) {
            String key = EPdfExtractType.key((EPdfExtractType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

