/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.gaeb;

import de.qfm.erp.service.model.internal.gaeb.EItemFormatType;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class ItemFormat {
    public static ItemFormat DEFAULT_LEVEL_FORMAT = ItemFormat.level((int)0, (String)"", (int)2, (String)"", (boolean)true);
    public static ItemFormat DEFAULT_POS_FORMAT = ItemFormat.level((int)0, (String)"", (int)4, (String)"", (boolean)true);
    @NonNull
    private final EItemFormatType itemFormatType;
    @NonNull
    private final String name;
    private final int level;
    private final int length;
    private final String align;
    private final boolean numeric;

    @Nonnull
    public static ItemFormat level(int level, @NonNull String name, int length, @NonNull String align, boolean numeric) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (align == null) {
            throw new NullPointerException("align is marked non-null but is null");
        }
        return new ItemFormat(EItemFormatType.LEVEL, name, level, length, align, numeric);
    }

    @Nonnull
    public static ItemFormat position(@NonNull String name, int length, @NonNull String align, boolean numeric) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (align == null) {
            throw new NullPointerException("align is marked non-null but is null");
        }
        return new ItemFormat(EItemFormatType.POSITION, name, -1, length, align, numeric);
    }

    @Nonnull
    public static ItemFormat index(@NonNull String name, int length, @NonNull String align, boolean numeric) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (align == null) {
            throw new NullPointerException("align is marked non-null but is null");
        }
        return new ItemFormat(EItemFormatType.INDEX, name, -1, length, align, numeric);
    }

    public ItemFormat(@NonNull EItemFormatType itemFormatType, @NonNull String name, int level, int length, String align, boolean numeric) {
        if (itemFormatType == null) {
            throw new NullPointerException("itemFormatType is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.itemFormatType = itemFormatType;
        this.name = name;
        this.level = level;
        this.length = length;
        this.align = align;
        this.numeric = numeric;
    }

    @NonNull
    public EItemFormatType getItemFormatType() {
        return this.itemFormatType;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLength() {
        return this.length;
    }

    public String getAlign() {
        return this.align;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemFormat)) {
            return false;
        }
        ItemFormat other = (ItemFormat)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.isNumeric() != other.isNumeric()) {
            return false;
        }
        EItemFormatType this$itemFormatType = this.getItemFormatType();
        EItemFormatType other$itemFormatType = other.getItemFormatType();
        if (this$itemFormatType == null ? other$itemFormatType != null : !this$itemFormatType.equals(other$itemFormatType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$align = this.getAlign();
        String other$align = other.getAlign();
        return !(this$align == null ? other$align != null : !this$align.equals(other$align));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getLength();
        result = result * 59 + (this.isNumeric() ? 79 : 97);
        EItemFormatType $itemFormatType = this.getItemFormatType();
        result = result * 59 + ($itemFormatType == null ? 43 : $itemFormatType.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $align = this.getAlign();
        result = result * 59 + ($align == null ? 43 : $align.hashCode());
        return result;
    }

    public String toString() {
        return "ItemFormat(itemFormatType=" + String.valueOf(this.getItemFormatType()) + ", name=" + this.getName() + ", level=" + this.getLevel() + ", length=" + this.getLength() + ", align=" + this.getAlign() + ", numeric=" + this.isNumeric() + ")";
    }
}

