/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.employee.payroll;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EWageAccountOn implements Translatable
{
    NONE,
    DAY,
    MONTH;

    private static final Map<String, EWageAccountOn> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EWageAccountOn lookup(@NonNull String candidate, @NonNull EWageAccountOn defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EWageAccountOn.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EWageAccountOn> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EWageAccountOn.key((String)candidate);
        return Optional.ofNullable((EWageAccountOn)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EWageAccountOn item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EWageAccountOn.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @NonNull
    public static EWageAccountOn lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EWageAccountOn.key((String)candidate);
        EWageAccountOn payrollItemUnit = (EWageAccountOn)LOOKUP.get(key);
        if (null == payrollItemUnit) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_ITEM_TYPE__WAGE_TYPE_CALCULATION_RESULT_TYPE), (String)candidate, EWageAccountOn.class, EWageAccountOn::allowedKeys);
        }
        return payrollItemUnit;
    }

    @Nonnull
    public String messageCode() {
        return "enum.payroll_item_type_wage_type_calculation_result_type." + EWageAccountOn.key((EWageAccountOn)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EWageAccountOn value : EWageAccountOn.values()) {
            String key = EWageAccountOn.key((EWageAccountOn)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

