/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.employee.payroll;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EDurationType implements Translatable
{
    NONE,
    DAY,
    HOUR;

    private static final Map<String, EDurationType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EDurationType lookup(@NonNull String candidate, @NonNull EDurationType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EDurationType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EDurationType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EDurationType.key((String)candidate);
        return Optional.ofNullable((EDurationType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EDurationType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EDurationType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @NonNull
    public static EDurationType lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EDurationType.key((String)candidate);
        EDurationType payrollItemUnit = (EDurationType)LOOKUP.get(key);
        if (null == payrollItemUnit) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_ITEM_TYPE__DURATION_TYPE), (String)candidate, EDurationType.class, EDurationType::allowedKeys);
        }
        return payrollItemUnit;
    }

    @Nonnull
    public String messageCode() {
        return "enum.payroll_item_type_duration_type." + EDurationType.key((EDurationType)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EDurationType value : EDurationType.values()) {
            String key = EDurationType.key((EDurationType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

