/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal;

import de.qfm.erp.service.model.jpa.quotation.Quotation;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WageMoveBucket {
    private static final Logger log = LogManager.getLogger(WageMoveBucket.class);
    @NonNull
    private final Quotation sourceStage;
    @NonNull
    private final Quotation targetStage;

    private WageMoveBucket(@NonNull Quotation sourceStage, @NonNull Quotation targetStage) {
        if (sourceStage == null) {
            throw new NullPointerException("sourceStage is marked non-null but is null");
        }
        if (targetStage == null) {
            throw new NullPointerException("targetStage is marked non-null but is null");
        }
        this.sourceStage = sourceStage;
        this.targetStage = targetStage;
    }

    public static WageMoveBucket of(@NonNull Quotation sourceStage, @NonNull Quotation targetStage) {
        if (sourceStage == null) {
            throw new NullPointerException("sourceStage is marked non-null but is null");
        }
        if (targetStage == null) {
            throw new NullPointerException("targetStage is marked non-null but is null");
        }
        return new WageMoveBucket(sourceStage, targetStage);
    }

    @NonNull
    public Quotation getSourceStage() {
        return this.sourceStage;
    }

    @NonNull
    public Quotation getTargetStage() {
        return this.targetStage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WageMoveBucket)) {
            return false;
        }
        WageMoveBucket other = (WageMoveBucket)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Quotation this$sourceStage = this.getSourceStage();
        Quotation other$sourceStage = other.getSourceStage();
        if (this$sourceStage == null ? other$sourceStage != null : !this$sourceStage.equals(other$sourceStage)) {
            return false;
        }
        Quotation this$targetStage = this.getTargetStage();
        Quotation other$targetStage = other.getTargetStage();
        return !(this$targetStage == null ? other$targetStage != null : !this$targetStage.equals(other$targetStage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WageMoveBucket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Quotation $sourceStage = this.getSourceStage();
        result = result * 59 + ($sourceStage == null ? 43 : $sourceStage.hashCode());
        Quotation $targetStage = this.getTargetStage();
        result = result * 59 + ($targetStage == null ? 43 : $targetStage.hashCode());
        return result;
    }

    public String toString() {
        return "WageMoveBucket(sourceStage=" + String.valueOf(this.getSourceStage()) + ", targetStage=" + String.valueOf(this.getTargetStage()) + ")";
    }
}

