/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal;

import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import java.util.Map;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StageMergeResult {
    private static final Logger log = LogManager.getLogger(StageMergeResult.class);
    @NonNull
    private final Quotation stage;
    @NonNull
    private final Map<QuotationPosition, QuotationPosition> positionMap;

    private StageMergeResult(@NonNull Quotation stage, @NonNull Map<QuotationPosition, QuotationPosition> positionMap) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (positionMap == null) {
            throw new NullPointerException("positionMap is marked non-null but is null");
        }
        this.stage = stage;
        this.positionMap = positionMap;
    }

    public static StageMergeResult of(@NonNull Quotation stage, @NonNull Map<QuotationPosition, QuotationPosition> positionMap) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (positionMap == null) {
            throw new NullPointerException("positionMap is marked non-null but is null");
        }
        return new StageMergeResult(stage, positionMap);
    }

    @NonNull
    public Quotation getStage() {
        return this.stage;
    }

    @NonNull
    public Map<QuotationPosition, QuotationPosition> getPositionMap() {
        return this.positionMap;
    }
}

