/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.jpa.EntityBase;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MergedBucket<T extends EntityBase> {
    private static final Logger log = LogManager.getLogger(MergedBucket.class);
    @NonNull
    private final Iterable<T> added;
    @NonNull
    private final Iterable<T> updated;
    @NonNull
    private final Iterable<T> deleted;

    @NonNull
    public Iterable<T> all() {
        return ImmutableList.builder().addAll(this.added).addAll(this.updated).addAll(this.deleted).build();
    }

    @NonNull
    public Iterable<T> existent() {
        return ImmutableList.builder().addAll(this.added).addAll(this.updated).build();
    }

    public static <T, V extends EntityBase> void printMergeBucket(@NonNull T root, @NonNull Class<V> childClass, @NonNull MergedBucket<V> mergedBucket) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (childClass == null) {
            throw new NullPointerException("childClass is marked non-null but is null");
        }
        if (mergedBucket == null) {
            throw new NullPointerException("mergedBucket is marked non-null but is null");
        }
        Class<?> rootClass = root.getClass();
        int amountAdded = Iterables.size((Iterable)mergedBucket.getAdded());
        int amountUpdated = Iterables.size((Iterable)mergedBucket.getUpdated());
        int amountDeleted = Iterables.size((Iterable)mergedBucket.getDeleted());
        log.info("Add: {} {} to {}: {}", (Object)amountAdded, (Object)childClass.getSimpleName(), (Object)rootClass.getSimpleName(), root);
        log.info("Update: {} {} to {}: {}", (Object)amountUpdated, (Object)childClass.getSimpleName(), (Object)rootClass.getSimpleName(), root);
        log.info("Remove: {} {} to {}: {}", (Object)amountDeleted, (Object)childClass.getSimpleName(), (Object)rootClass.getSimpleName(), root);
    }

    private MergedBucket(@NonNull Iterable<T> added, @NonNull Iterable<T> updated, @NonNull Iterable<T> deleted) {
        if (added == null) {
            throw new NullPointerException("added is marked non-null but is null");
        }
        if (updated == null) {
            throw new NullPointerException("updated is marked non-null but is null");
        }
        if (deleted == null) {
            throw new NullPointerException("deleted is marked non-null but is null");
        }
        this.added = added;
        this.updated = updated;
        this.deleted = deleted;
    }

    public static <T extends EntityBase> MergedBucket<T> of(@NonNull Iterable<T> added, @NonNull Iterable<T> updated, @NonNull Iterable<T> deleted) {
        if (added == null) {
            throw new NullPointerException("added is marked non-null but is null");
        }
        if (updated == null) {
            throw new NullPointerException("updated is marked non-null but is null");
        }
        if (deleted == null) {
            throw new NullPointerException("deleted is marked non-null but is null");
        }
        return new MergedBucket(added, updated, deleted);
    }

    @NonNull
    public Iterable<T> getAdded() {
        return this.added;
    }

    @NonNull
    public Iterable<T> getUpdated() {
        return this.updated;
    }

    @NonNull
    public Iterable<T> getDeleted() {
        return this.deleted;
    }
}

