/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal;

import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import java.util.Map;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeasurementMoveBucket {
    private static final Logger log = LogManager.getLogger(MeasurementMoveBucket.class);
    @NonNull
    private final Measurement measurement;
    @NonNull
    private final Quotation sourceStage;
    @NonNull
    private final Quotation targetStage;
    @NonNull
    private final Map<QuotationPosition, QuotationPosition> positionMap;

    private MeasurementMoveBucket(@NonNull Measurement measurement, @NonNull Quotation sourceStage, @NonNull Quotation targetStage, @NonNull Map<QuotationPosition, QuotationPosition> positionMap) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (sourceStage == null) {
            throw new NullPointerException("sourceStage is marked non-null but is null");
        }
        if (targetStage == null) {
            throw new NullPointerException("targetStage is marked non-null but is null");
        }
        if (positionMap == null) {
            throw new NullPointerException("positionMap is marked non-null but is null");
        }
        this.measurement = measurement;
        this.sourceStage = sourceStage;
        this.targetStage = targetStage;
        this.positionMap = positionMap;
    }

    public static MeasurementMoveBucket of(@NonNull Measurement measurement, @NonNull Quotation sourceStage, @NonNull Quotation targetStage, @NonNull Map<QuotationPosition, QuotationPosition> positionMap) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (sourceStage == null) {
            throw new NullPointerException("sourceStage is marked non-null but is null");
        }
        if (targetStage == null) {
            throw new NullPointerException("targetStage is marked non-null but is null");
        }
        if (positionMap == null) {
            throw new NullPointerException("positionMap is marked non-null but is null");
        }
        return new MeasurementMoveBucket(measurement, sourceStage, targetStage, positionMap);
    }

    @NonNull
    public Measurement getMeasurement() {
        return this.measurement;
    }

    @NonNull
    public Quotation getSourceStage() {
        return this.sourceStage;
    }

    @NonNull
    public Quotation getTargetStage() {
        return this.targetStage;
    }

    @NonNull
    public Map<QuotationPosition, QuotationPosition> getPositionMap() {
        return this.positionMap;
    }
}

