/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.message.Translatable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EStringSearchFilterType implements Translatable
{
    ALL("all"),
    EQ("eq"),
    STARTS_WITH("starts_with"),
    ENDS_WITH("ends_with"),
    CONTAINS("contains");

    private final String value;
    private static final Map<String, EStringSearchFilterType> LOOKUP;

    private EStringSearchFilterType(String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EStringSearchFilterType lookup(@NonNull String candidate, @NonNull EStringSearchFilterType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EStringSearchFilterType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EStringSearchFilterType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EStringSearchFilterType.key((String)candidate);
        return Optional.ofNullable((EStringSearchFilterType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EStringSearchFilterType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EStringSearchFilterType.key((String)item.getValue());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.string_search_filter." + this.value;
    }

    public String getValue() {
        return this.value;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EStringSearchFilterType value : EStringSearchFilterType.values()) {
            String key = EStringSearchFilterType.key((EStringSearchFilterType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

