/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.external.psx.search;

import de.qfm.erp.service.model.external.psx.search.PsxHighlightCommon;
import java.util.Objects;
import lombok.NonNull;

public abstract class PsxSearchItem {
    private final boolean remote = true;
    private long id;
    @NonNull
    private String text;
    @NonNull
    private Iterable<PsxHighlightCommon> textHighlights;
    @NonNull
    private String details;
    @NonNull
    private String field;
    @NonNull
    private String fieldName;
    @NonNull
    private Iterable<PsxHighlightCommon> detailHighlights;

    protected PsxSearchItem() {
    }

    protected PsxSearchItem(long id, @NonNull String text, @NonNull Iterable<PsxHighlightCommon> textHighlights, @NonNull String details, @NonNull String field, @NonNull String fieldName, @NonNull Iterable<PsxHighlightCommon> detailHighlights) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (textHighlights == null) {
            throw new NullPointerException("textHighlights is marked non-null but is null");
        }
        if (details == null) {
            throw new NullPointerException("details is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (detailHighlights == null) {
            throw new NullPointerException("detailHighlights is marked non-null but is null");
        }
        this.id = id;
        this.text = text;
        this.textHighlights = textHighlights;
        this.details = details;
        this.field = field;
        this.fieldName = fieldName;
        this.detailHighlights = detailHighlights;
    }

    public boolean isRemote() {
        Objects.requireNonNull(this);
        return true;
    }

    public long getId() {
        return this.id;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    @NonNull
    public Iterable<PsxHighlightCommon> getTextHighlights() {
        return this.textHighlights;
    }

    @NonNull
    public String getDetails() {
        return this.details;
    }

    @NonNull
    public String getField() {
        return this.field;
    }

    @NonNull
    public String getFieldName() {
        return this.fieldName;
    }

    @NonNull
    public Iterable<PsxHighlightCommon> getDetailHighlights() {
        return this.detailHighlights;
    }
}

