/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.external.psx;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="The Paging Pax Class")
public class ExtPsxPageCommon<T> {
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The Requested Page", accessMode=Schema.AccessMode.READ_ONLY)
    private int page;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.REQUIRED, description="The Requested Size")
    private int size;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.REQUIRED, description="The Resulting Pages for the requested Size")
    private int totalPages;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.REQUIRED, description="The Resulting Amount of Items")
    private long totalElements;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.REQUIRED, description="The Resulting Items")
    private List<T> items;

    public ExtPsxPageCommon(int page, int size, int totalPages, long totalElements, List<T> items) {
        this.page = page;
        this.size = size;
        this.totalPages = totalPages;
        this.totalElements = totalElements;
        this.items = items;
    }

    protected ExtPsxPageCommon() {
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public List<T> getItems() {
        return this.items;
    }

    public String toString() {
        return "ExtPsxPageCommon(page=" + this.getPage() + ", size=" + this.getSize() + ", totalPages=" + this.getTotalPages() + ", totalElements=" + this.getTotalElements() + ", items=" + String.valueOf(this.getItems()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtPsxPageCommon)) {
            return false;
        }
        ExtPsxPageCommon other = (ExtPsxPageCommon)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getTotalElements() != other.getTotalElements()) {
            return false;
        }
        List this$items = this.getItems();
        List other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtPsxPageCommon;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getSize();
        result = result * 59 + this.getTotalPages();
        long $totalElements = this.getTotalElements();
        result = result * 59 + (int)($totalElements >>> 32 ^ $totalElements);
        List $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }
}

