/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.external.psx;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;

public class ExtPsxNotifyRequest {
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_WRITE, description="The Entity Type of the Origin within PSX", allowableValues={"PROJECT_TEAM", "ENTITY", "STAGE", "PROJECT"})
    @NotBlank
    @Size(max=250)
    private @NotBlank @Size(max=250) String entityType;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_WRITE, description="Origin Id for the Notify Entity (PSX.*.referenceId)", allowableValues={"PROJECT_TEAM", "ENTITY", "STAGE", "PROJECT"})
    @NotBlank
    @Size(max=250)
    private @NotBlank @Size(max=250) String entityReferenceId;

    private ExtPsxNotifyRequest(String entityType, String entityReferenceId) {
        this.entityType = entityType;
        this.entityReferenceId = entityReferenceId;
    }

    public static ExtPsxNotifyRequest of(String entityType, String entityReferenceId) {
        return new ExtPsxNotifyRequest(entityType, entityReferenceId);
    }

    public ExtPsxNotifyRequest() {
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityReferenceId() {
        return this.entityReferenceId;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public void setEntityReferenceId(String entityReferenceId) {
        this.entityReferenceId = entityReferenceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtPsxNotifyRequest)) {
            return false;
        }
        ExtPsxNotifyRequest other = (ExtPsxNotifyRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$entityType = this.getEntityType();
        String other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$entityReferenceId = this.getEntityReferenceId();
        String other$entityReferenceId = other.getEntityReferenceId();
        return !(this$entityReferenceId == null ? other$entityReferenceId != null : !this$entityReferenceId.equals(other$entityReferenceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtPsxNotifyRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $entityReferenceId = this.getEntityReferenceId();
        result = result * 59 + ($entityReferenceId == null ? 43 : $entityReferenceId.hashCode());
        return result;
    }

    public String toString() {
        return "ExtPsxNotifyRequest(entityType=" + this.getEntityType() + ", entityReferenceId=" + this.getEntityReferenceId() + ")";
    }
}

