/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.external.psx;

import de.qfm.erp.common.response.EntityBaseCommon;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.annotation.Nullable;

@Schema(description="All PSX Construction Site Details")
public class ExtPsxConstructionSiteCommon
extends EntityBaseCommon {
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="Reference Id Name of a Construction Site")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String referenceId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="PSX Number of the Construction Site")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String psxNumber;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="construction site project number")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String projectNumber;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="general description")
    @NotNull
    @Size(max=4000)
    private @NotNull @Size(max=4000) String generalDescription;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="procedure description")
    @NotNull
    @Size(max=4000)
    private @NotNull @Size(max=4000) String procedureDescription;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="street")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String street;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="street no")
    @NotNull
    @Size(max=50)
    private @NotNull @Size(max=50) String streetNo;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="zip code")
    @NotNull
    @Size(max=50)
    private @NotNull @Size(max=50) String zipCode;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="city")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String city;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="berlin district", allowableValues={"MITTE", "FRIEDRICHSHAIN_KREUZBERG", "PANKOW", "CHARLOTTENBURG_WILMERSDORF", "SPANDAU", "STEGLITZ_ZEHLENDORF", "TEMPELHOF_SCHOENEBERG", "NEUKOELLN", "TREPTOW_KOEPENICK", "MARZAHN_HELLERSDORF", "LICHTENBERG", "REINICKENDORF"})
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String berlinDistrict;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="start of work planned date/time")
    private LocalDateTime startOfWorkPlannedDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="end of work planned date/time")
    private LocalDateTime endOfWorkPlannedDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="start of work as-is date/time")
    private LocalDateTime startOfWorkAsIsDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="end of work as-is date/time")
    private LocalDateTime endOfWorkAsIsDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="calculated duration")
    private Duration workDuration;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="custom date/time 1")
    private LocalDateTime customDateTime1;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="custom date/time 2")
    private LocalDateTime customDateTime2;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="Contact Person On-Site")
    private String contactPersonOnSite;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="current state.id")
    private long constructionSiteStateId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="current state.name", allowableValues={"UNKNOWN", "PLANNED", "NEW", "IN_PROGRESS", "OUTAGE", "FINISHED", "SENT", "CANCELLED", "ARCHIVED", "DELETED"})
    @Size(max=250)
    private @Size(max=250) String constructionSiteStateName;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="current state.createdBy")
    @Size(max=250)
    private @Size(max=250) String constructionSiteStateBy;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="current state.createdBy")
    private LocalDateTime constructionSiteStateSince;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="executing company.id")
    private long executingCompanyId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="executing company.name")
    @Size(max=250)
    private @Size(max=250) String executingCompanyName;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="release order id")
    private Long releaseOrderId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="release order psx number")
    @Size(max=250)
    @NotNull
    private @Size(max=250) @NotNull String releaseOrderPsxNumber;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="Type of the Release Order", allowableValues={"UNKNOWN", "STANDARD", "INCIDENT"})
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String releaseOrderType;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="ReleaseOrder.orderNumber")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String releaseOrderOrderNumber;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="ReleaseOrder.state.name", allowableValues={"UNKNOWN", "PLANNED", "NEW", "IN_PROGRESS", "ARCHIVED", "CANCELLED", "DELETED"})
    @Size(max=250)
    @NotNull
    private @Size(max=250) @NotNull String releaseOrderStateName;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="The PSX StageGroup Id")
    @NotNull
    private Long stageGroupId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.Id of the Stage of the assigned StageGroup")
    @NotNull
    private String stageReferenceId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.Alias of the State of the assigned StageGroup")
    @NotNull
    private String stageAlias;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.stageText of the State of the assigned StageGroup")
    @NotNull
    private String stageText;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.Id of the Entity of the assigned StageGroup")
    @NotBlank
    @Size(min=0, max=250)
    private @NotBlank @Size(min=0, max=250) String entityReferenceId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.EntityNumber of the Entity of the assigned StageGroup")
    @NotBlank
    @Size(min=0, max=250)
    private @NotBlank @Size(min=0, max=250) String entityNumber;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.Alias of the Entity of the assigned StageGroup")
    @NotBlank
    @Size(min=0, max=250)
    private @NotBlank @Size(min=0, max=250) String entityAlias;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.ID of the ProjectTeam of the assigned StageGroup")
    @NotBlank
    @Size(min=0, max=250)
    private @NotBlank @Size(min=0, max=250) String projectTeamReferenceId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.Name of the ProjectTeam of the assigned StageGroup")
    @NotBlank
    @Size(min=0, max=250)
    private @NotBlank @Size(min=0, max=250) String projectTeamName;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.ReferenceId of the ProjectTeam of the assigned StageGroup")
    @NotBlank
    @Size(min=0, max=250)
    private @NotBlank @Size(min=0, max=250) String projectTeamAlias;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="the PSX.ID of the Customer of the assigned RO.StageGroup")
    @Nullable
    private Long customerId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.ID of the Customer of the assigned RO.StageGroup")
    @NotNull
    @Size(min=0, max=250)
    private @NotNull @Size(min=0, max=250) String customerReferenceId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="the AppQ.Name of the ProjectTeam of the assigned RO.StageGroup")
    @NotNull
    @Size(min=0, max=250)
    private @NotNull @Size(min=0, max=250) String customerName;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="The Sharepoint Sync State")
    @NotNull
    @Size(min=0, max=50)
    private @NotNull @Size(min=0, max=50) String sharepointState;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="The Sharepoint Browser URL")
    @NotNull
    @Size(min=0, max=500)
    private @NotNull @Size(min=0, max=500) String sharepointUrl;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="The Sharepoint Site Id")
    @NotNull
    @Size(min=0, max=250)
    private @NotNull @Size(min=0, max=250) String sharepointSiteId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="The Sharepoint Drive Id")
    @NotNull
    @Size(min=0, max=250)
    private @NotNull @Size(min=0, max=250) String sharepointDriveId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="The Sharepoint Drive Item Id")
    @NotNull
    @Size(min=0, max=250)
    private @NotNull @Size(min=0, max=250) String sharepointDriveItemId;

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getPsxNumber() {
        return this.psxNumber;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getGeneralDescription() {
        return this.generalDescription;
    }

    public String getProcedureDescription() {
        return this.procedureDescription;
    }

    public String getStreet() {
        return this.street;
    }

    public String getStreetNo() {
        return this.streetNo;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getBerlinDistrict() {
        return this.berlinDistrict;
    }

    public LocalDateTime getStartOfWorkPlannedDateTime() {
        return this.startOfWorkPlannedDateTime;
    }

    public LocalDateTime getEndOfWorkPlannedDateTime() {
        return this.endOfWorkPlannedDateTime;
    }

    public LocalDateTime getStartOfWorkAsIsDateTime() {
        return this.startOfWorkAsIsDateTime;
    }

    public LocalDateTime getEndOfWorkAsIsDateTime() {
        return this.endOfWorkAsIsDateTime;
    }

    public Duration getWorkDuration() {
        return this.workDuration;
    }

    public LocalDateTime getCustomDateTime1() {
        return this.customDateTime1;
    }

    public LocalDateTime getCustomDateTime2() {
        return this.customDateTime2;
    }

    public String getContactPersonOnSite() {
        return this.contactPersonOnSite;
    }

    public long getConstructionSiteStateId() {
        return this.constructionSiteStateId;
    }

    public String getConstructionSiteStateName() {
        return this.constructionSiteStateName;
    }

    public String getConstructionSiteStateBy() {
        return this.constructionSiteStateBy;
    }

    public LocalDateTime getConstructionSiteStateSince() {
        return this.constructionSiteStateSince;
    }

    public long getExecutingCompanyId() {
        return this.executingCompanyId;
    }

    public String getExecutingCompanyName() {
        return this.executingCompanyName;
    }

    public Long getReleaseOrderId() {
        return this.releaseOrderId;
    }

    public String getReleaseOrderPsxNumber() {
        return this.releaseOrderPsxNumber;
    }

    public String getReleaseOrderType() {
        return this.releaseOrderType;
    }

    public String getReleaseOrderOrderNumber() {
        return this.releaseOrderOrderNumber;
    }

    public String getReleaseOrderStateName() {
        return this.releaseOrderStateName;
    }

    public Long getStageGroupId() {
        return this.stageGroupId;
    }

    public String getStageReferenceId() {
        return this.stageReferenceId;
    }

    public String getStageAlias() {
        return this.stageAlias;
    }

    public String getStageText() {
        return this.stageText;
    }

    public String getEntityReferenceId() {
        return this.entityReferenceId;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public String getProjectTeamReferenceId() {
        return this.projectTeamReferenceId;
    }

    public String getProjectTeamName() {
        return this.projectTeamName;
    }

    public String getProjectTeamAlias() {
        return this.projectTeamAlias;
    }

    @Nullable
    public Long getCustomerId() {
        return this.customerId;
    }

    public String getCustomerReferenceId() {
        return this.customerReferenceId;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getSharepointState() {
        return this.sharepointState;
    }

    public String getSharepointUrl() {
        return this.sharepointUrl;
    }

    public String getSharepointSiteId() {
        return this.sharepointSiteId;
    }

    public String getSharepointDriveId() {
        return this.sharepointDriveId;
    }

    public String getSharepointDriveItemId() {
        return this.sharepointDriveItemId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setPsxNumber(String psxNumber) {
        this.psxNumber = psxNumber;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    public void setGeneralDescription(String generalDescription) {
        this.generalDescription = generalDescription;
    }

    public void setProcedureDescription(String procedureDescription) {
        this.procedureDescription = procedureDescription;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setStreetNo(String streetNo) {
        this.streetNo = streetNo;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setBerlinDistrict(String berlinDistrict) {
        this.berlinDistrict = berlinDistrict;
    }

    public void setStartOfWorkPlannedDateTime(LocalDateTime startOfWorkPlannedDateTime) {
        this.startOfWorkPlannedDateTime = startOfWorkPlannedDateTime;
    }

    public void setEndOfWorkPlannedDateTime(LocalDateTime endOfWorkPlannedDateTime) {
        this.endOfWorkPlannedDateTime = endOfWorkPlannedDateTime;
    }

    public void setStartOfWorkAsIsDateTime(LocalDateTime startOfWorkAsIsDateTime) {
        this.startOfWorkAsIsDateTime = startOfWorkAsIsDateTime;
    }

    public void setEndOfWorkAsIsDateTime(LocalDateTime endOfWorkAsIsDateTime) {
        this.endOfWorkAsIsDateTime = endOfWorkAsIsDateTime;
    }

    public void setWorkDuration(Duration workDuration) {
        this.workDuration = workDuration;
    }

    public void setCustomDateTime1(LocalDateTime customDateTime1) {
        this.customDateTime1 = customDateTime1;
    }

    public void setCustomDateTime2(LocalDateTime customDateTime2) {
        this.customDateTime2 = customDateTime2;
    }

    public void setContactPersonOnSite(String contactPersonOnSite) {
        this.contactPersonOnSite = contactPersonOnSite;
    }

    public void setConstructionSiteStateId(long constructionSiteStateId) {
        this.constructionSiteStateId = constructionSiteStateId;
    }

    public void setConstructionSiteStateName(String constructionSiteStateName) {
        this.constructionSiteStateName = constructionSiteStateName;
    }

    public void setConstructionSiteStateBy(String constructionSiteStateBy) {
        this.constructionSiteStateBy = constructionSiteStateBy;
    }

    public void setConstructionSiteStateSince(LocalDateTime constructionSiteStateSince) {
        this.constructionSiteStateSince = constructionSiteStateSince;
    }

    public void setExecutingCompanyId(long executingCompanyId) {
        this.executingCompanyId = executingCompanyId;
    }

    public void setExecutingCompanyName(String executingCompanyName) {
        this.executingCompanyName = executingCompanyName;
    }

    public void setReleaseOrderId(Long releaseOrderId) {
        this.releaseOrderId = releaseOrderId;
    }

    public void setReleaseOrderPsxNumber(String releaseOrderPsxNumber) {
        this.releaseOrderPsxNumber = releaseOrderPsxNumber;
    }

    public void setReleaseOrderType(String releaseOrderType) {
        this.releaseOrderType = releaseOrderType;
    }

    public void setReleaseOrderOrderNumber(String releaseOrderOrderNumber) {
        this.releaseOrderOrderNumber = releaseOrderOrderNumber;
    }

    public void setReleaseOrderStateName(String releaseOrderStateName) {
        this.releaseOrderStateName = releaseOrderStateName;
    }

    public void setStageGroupId(Long stageGroupId) {
        this.stageGroupId = stageGroupId;
    }

    public void setStageReferenceId(String stageReferenceId) {
        this.stageReferenceId = stageReferenceId;
    }

    public void setStageAlias(String stageAlias) {
        this.stageAlias = stageAlias;
    }

    public void setStageText(String stageText) {
        this.stageText = stageText;
    }

    public void setEntityReferenceId(String entityReferenceId) {
        this.entityReferenceId = entityReferenceId;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public void setEntityAlias(String entityAlias) {
        this.entityAlias = entityAlias;
    }

    public void setProjectTeamReferenceId(String projectTeamReferenceId) {
        this.projectTeamReferenceId = projectTeamReferenceId;
    }

    public void setProjectTeamName(String projectTeamName) {
        this.projectTeamName = projectTeamName;
    }

    public void setProjectTeamAlias(String projectTeamAlias) {
        this.projectTeamAlias = projectTeamAlias;
    }

    public void setCustomerId(@Nullable Long customerId) {
        this.customerId = customerId;
    }

    public void setCustomerReferenceId(String customerReferenceId) {
        this.customerReferenceId = customerReferenceId;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setSharepointState(String sharepointState) {
        this.sharepointState = sharepointState;
    }

    public void setSharepointUrl(String sharepointUrl) {
        this.sharepointUrl = sharepointUrl;
    }

    public void setSharepointSiteId(String sharepointSiteId) {
        this.sharepointSiteId = sharepointSiteId;
    }

    public void setSharepointDriveId(String sharepointDriveId) {
        this.sharepointDriveId = sharepointDriveId;
    }

    public void setSharepointDriveItemId(String sharepointDriveItemId) {
        this.sharepointDriveItemId = sharepointDriveItemId;
    }
}

