/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.exception.response;

import de.qfm.erp.service.model.internal.fieldname.FieldName;

public class ResourceNotFoundException
extends RuntimeException {
    private final String clazz;
    private final FieldName fieldName;
    private final String value;

    @Override
    public String getMessage() {
        return String.format("Resource: %s with field: %s and value: %s cannot be found", this.clazz, this.fieldName.path(), this.value);
    }

    private ResourceNotFoundException(String clazz, FieldName fieldName, String value) {
        this.clazz = clazz;
        this.fieldName = fieldName;
        this.value = value;
    }

    public static ResourceNotFoundException of(String clazz, FieldName fieldName, String value) {
        return new ResourceNotFoundException(clazz, fieldName, value);
    }

    public String getClazz() {
        return this.clazz;
    }

    public FieldName getFieldName() {
        return this.fieldName;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "ResourceNotFoundException(clazz=" + this.getClazz() + ", fieldName=" + String.valueOf(this.getFieldName()) + ", value=" + this.getValue() + ")";
    }
}

