/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.xstream;

import com.google.common.collect.Maps;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import de.qfm.erp.service.model.external.gaeb.generic.ListOrdered;
import de.qfm.erp.service.model.external.gaeb.generic.ListUnordered;
import de.qfm.erp.service.model.external.gaeb.generic.Paragraph;
import de.qfm.erp.service.model.external.gaeb.generic.Text;
import de.qfm.erp.service.model.external.gaeb.generic.TextComplement;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GaebParagraphConverter
implements Converter {
    private static final Logger log = LogManager.getLogger(GaebParagraphConverter.class);

    public boolean canConvert(Class clazz) {
        return clazz.equals(Paragraph.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Text text = (Text)value;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Paragraph paragraph = new Paragraph();
        paragraph.setObjects((List)Lists.newArrayList());
        while (reader.hasMoreChildren()) {
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            int attributeCount = reader.getAttributeCount();
            if (attributeCount > 0) {
                for (int i = 0; i < attributeCount; ++i) {
                    String attributeName = reader.getAttributeName(i);
                    String attributeValue = reader.getAttribute(i);
                    attributes.put(attributeName, attributeValue);
                }
            }
            reader.moveDown();
            String nodeName = reader.getNodeName();
            String value = reader.getValue();
            if (StringUtils.length((CharSequence)value) > 0) {
                boolean moreChildren = reader.hasMoreChildren();
                if ("span".equals(nodeName)) {
                    paragraph.getObjects().add(value);
                } else if ("TextComplement".equals(nodeName) && moreChildren) {
                    TextComplement textComplement = (TextComplement)context.convertAnother((Object)paragraph, TextComplement.class);
                    textComplement.setKind(attributes.getOrDefault("Kind", ""));
                    textComplement.setMarkLabel(attributes.getOrDefault("MarkLbl", ""));
                    paragraph.getObjects().add(textComplement);
                } else if ("ul".equals(nodeName) && moreChildren) {
                    t = (ListUnordered)context.convertAnother((Object)paragraph, ListUnordered.class);
                    paragraph.getObjects().add(t);
                } else if ("ol".equals(nodeName) && moreChildren) {
                    t = (ListOrdered)context.convertAnother((Object)paragraph, ListOrdered.class);
                    paragraph.getObjects().add(t);
                } else {
                    log.warn("Illegal Node Name: {}", (Object)nodeName);
                }
            }
            reader.moveUp();
        }
        return paragraph;
    }
}

