/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.comparator.quotation;

import com.google.common.base.MoreObjects;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionComparator;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionGroupingLevelComparator;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionSequentialNumberComparator;
import de.qfm.erp.service.model.internal.quotation.EStagePositionSortOption;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class QuotationPositionDefaultComparator
extends QuotationPositionComparator {
    private static final Logger log = LogManager.getLogger(QuotationPositionDefaultComparator.class);

    public int compare(@NonNull QuotationPosition left, @NonNull QuotationPosition right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return 0;
    }

    public QuotationPositionComparator from(@NonNull Quotation stage) {
        boolean isCostEstimate;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EStagePositionSortOption stagePositionSortOption = (EStagePositionSortOption)MoreObjects.firstNonNull((Object)stage.getStagePositionSortOption(), (Object)EStagePositionSortOption.NONE);
        EQStageType stageType = stage.getStageType();
        boolean isOld = stage.getOrigin() == EStageOrigin.QUANTE_V1;
        boolean bl = isCostEstimate = EQStageType.COMMISSION__COST_ESTIMATE == stageType;
        if (!isOld && isCostEstimate || EStagePositionSortOption.MANUAL == stagePositionSortOption) {
            return QuotationPositionSequentialNumberComparator.of();
        }
        return QuotationPositionGroupingLevelComparator.of((!isOld ? 1 : 0) != 0);
    }

    private QuotationPositionDefaultComparator() {
    }

    public static QuotationPositionDefaultComparator of() {
        return new QuotationPositionDefaultComparator();
    }
}

