/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.comparator.measurement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import de.qfm.erp.service.helper.comparator.measurement.MeasurementPositionComparator;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementPositionGroupingLevelComparator
extends MeasurementPositionComparator {
    private static final Logger log = LogManager.getLogger(MeasurementPositionGroupingLevelComparator.class);
    private final boolean considerPositionNumber;

    public int compare(@NonNull MeasurementPosition left, @NonNull MeasurementPosition right) {
        Quotation rightQuotation;
        long addendumNumberRight;
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        Quotation leftQuotation = left.getQuotation();
        long addendumNumberLeft = null != leftQuotation ? (Long)MoreObjects.firstNonNull((Object)leftQuotation.getAddendumNumber(), (Object)0L) : 0L;
        int i = Longs.compare((long)addendumNumberLeft, (long)(addendumNumberRight = null != (rightQuotation = right.getQuotation()) ? (Long)MoreObjects.firstNonNull((Object)rightQuotation.getAddendumNumber(), (Object)0L) : 0L));
        if (i != 0) {
            return i;
        }
        i = MeasurementPositionGroupingLevelComparator.strCmp((String)left.getGroupingElementLevel1(), (String)right.getGroupingElementLevel1());
        if (i != 0) {
            return i;
        }
        i = MeasurementPositionGroupingLevelComparator.strCmp((String)left.getGroupingElementLevel2(), (String)right.getGroupingElementLevel2());
        if (i != 0) {
            return i;
        }
        i = MeasurementPositionGroupingLevelComparator.strCmp((String)left.getGroupingElementLevel3(), (String)right.getGroupingElementLevel3());
        if (i != 0) {
            return i;
        }
        i = MeasurementPositionGroupingLevelComparator.strCmp((String)left.getGroupingElementLevel4(), (String)right.getGroupingElementLevel4());
        if (i != 0) {
            return i;
        }
        if (this.considerPositionNumber && (i = MeasurementPositionGroupingLevelComparator.strCmp((String)left.getQuotationPositionNumber(), (String)right.getQuotationPositionNumber())) != 0) {
            return i;
        }
        Integer leftSequenceNumber = (Integer)MoreObjects.firstNonNull((Object)left.getSequenceNumberMeasurementStandard(), (Object)0);
        Integer rightSequenceNumber = (Integer)MoreObjects.firstNonNull((Object)right.getSequenceNumberMeasurementStandard(), (Object)0);
        return Ints.compare((int)leftSequenceNumber, (int)rightSequenceNumber);
    }

    @VisibleForTesting
    public static int strCmp(@Nullable String leftCandidate, @Nullable String rightCandidate) {
        String left = StringUtils.trimToNull((String)leftCandidate);
        String right = StringUtils.trimToNull((String)rightCandidate);
        return StringUtils.compare((String)left, (String)right, (boolean)false);
    }

    public MeasurementPositionGroupingLevelComparator from(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        return this;
    }

    private MeasurementPositionGroupingLevelComparator(boolean considerPositionNumber) {
        this.considerPositionNumber = considerPositionNumber;
    }

    public static MeasurementPositionGroupingLevelComparator of(boolean considerPositionNumber) {
        return new MeasurementPositionGroupingLevelComparator(considerPositionNumber);
    }
}

