/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.CharMatcher;
import de.qfm.erp.service.model.internal.user.AutoCompleteUser;
import de.qfm.erp.service.model.internal.user.ScoredUser;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserAutocompleteScorer<T extends AutoCompleteUser> {
    private static final Logger log = LogManager.getLogger(UserAutocompleteScorer.class);
    private static final LevenshteinDistance DIST = LevenshteinDistance.getDefaultInstance();
    private static final int NOT_CONTAIN_PENALTY = 100;
    private static final int NOT_START_WITH_PENALTY = 25;
    private static final int UNEQUAL_LENGTH_PENALTY = 10;
    @NonNull
    private final Iterable<String> terms;
    private static final CharMatcher DIGIT = CharMatcher.inRange((char)'0', (char)'9').precomputed();

    @Nonnull
    public ScoredUser<T> score(@NonNull T item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return ScoredUser.of((int)this.internalScore(item), item);
    }

    private int internalScore(@NonNull AutoCompleteUser user) {
        String personalNumberAsString;
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        AtomicInteger penalty = new AtomicInteger();
        boolean onlyNumericTerms = this.onlyNumericTerms(this.terms);
        boolean onlyTextTerms = this.onlyTextTerms(this.terms);
        Integer personalNumber = user.getPersonalNumber();
        String string = personalNumberAsString = null == personalNumber ? "" : Integer.toString(personalNumber);
        if (onlyNumericTerms) {
            this.terms.forEach(term -> this.score(term, personalNumberAsString).ifPresent(penalty::addAndGet));
        } else if (onlyTextTerms) {
            this.terms.forEach(term -> {
                this.score(term, user.getFirstName()).ifPresent(penalty::addAndGet);
                this.score(term, user.getLastName()).ifPresent(penalty::addAndGet);
            });
        } else {
            this.terms.forEach(term -> {
                this.score(term, user.getFirstName()).ifPresent(penalty::addAndGet);
                this.score(term, user.getLastName()).ifPresent(penalty::addAndGet);
                this.score(term, personalNumberAsString).ifPresent(penalty::addAndGet);
            });
        }
        return penalty.get();
    }

    private boolean onlyNumericTerms(@NonNull Iterable<String> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        for (String term : terms) {
            if (DIGIT.matchesAllOf((CharSequence)term)) continue;
            return false;
        }
        return true;
    }

    private boolean onlyTextTerms(@NonNull Iterable<String> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        for (String term : terms) {
            if (!DIGIT.matchesAllOf((CharSequence)term)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    private Optional<Integer> score(@NonNull String term, @Nullable String value) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        String safeValue = StringUtils.trimToEmpty((String)value);
        if (StringUtils.isNotBlank((CharSequence)safeValue)) {
            int startsWithPenalty = StringUtils.startsWithIgnoreCase((CharSequence)value, (CharSequence)term) ? 0 : 25;
            int containsPenalty = StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)term) ? 0 : 100;
            int lengthPenalty = safeValue.length() == term.length() ? 0 : 10;
            Integer dist = startsWithPenalty + containsPenalty + lengthPenalty + 2 * DIST.apply((CharSequence)term, (CharSequence)safeValue);
            return Optional.of(dist);
        }
        return Optional.of(100);
    }

    private UserAutocompleteScorer(@NonNull Iterable<String> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        this.terms = terms;
    }

    public static <T extends AutoCompleteUser> UserAutocompleteScorer<T> of(@NonNull Iterable<String> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        return new UserAutocompleteScorer(terms);
    }
}

