/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class MapsHelper {
    @Nonnull
    public static <K, V, W> Map<V, W> reduce(@Nonnull Iterable<K> it, @NonNull Function<K, V> keyFn, @NonNull Function<K, W> valueFn, @NonNull W identity, @NonNull BinaryOperator<W> binaryOperator) {
        if (keyFn == null) {
            throw new NullPointerException("keyFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (binaryOperator == null) {
            throw new NullPointerException("binaryOperator is marked non-null but is null");
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        it.forEach(item -> {
            Object apply = keyFn.apply(item);
            Object value = valueFn.apply(item);
            Object existing = map.getOrDefault(apply, identity);
            Object operationApplied = binaryOperator.apply(existing, value);
            map.put(apply, operationApplied);
        });
        return ImmutableMap.copyOf((Map)map);
    }

    @Nonnull
    public static <K, V> Map<V, K> mapFirst(@Nonnull Iterable<K> it, @NonNull Function<K, V> fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        it.forEach(item -> {
            Object apply = fn.apply(item);
            if (null == apply) {
                throw new IllegalArgumentException(String.format("Key Function resolved to null for: %s", item));
            }
            if (!map.containsKey(apply)) {
                map.put(apply, item);
            }
        });
        return ImmutableMap.copyOf((Map)map);
    }

    @Nonnull
    public static <K, V, W> Map<V, W> mapFirst(@Nonnull Iterable<K> it, @NonNull Function<K, V> keyFn, @NonNull Function<K, W> valueFn) {
        if (keyFn == null) {
            throw new NullPointerException("keyFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        it.forEach(item -> {
            Object keyApply = keyFn.apply(item);
            Object valuepply = valueFn.apply(item);
            if (null == keyApply) {
                throw new IllegalArgumentException(String.format("Key Function resolved to null for: %s", item));
            }
            if (!map.containsKey(keyApply)) {
                map.put(keyApply, valuepply);
            }
        });
        return ImmutableMap.copyOf((Map)map);
    }

    @Nonnull
    public static <K, V> Map<V, K> mapWithoutDuplicates(@Nonnull Iterable<K> it, @NonNull Function<K, V> fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        HashSet handled = Sets.newHashSet();
        LinkedHashMap map = Maps.newLinkedHashMap();
        it.forEach(item -> {
            Object apply = fn.apply(item);
            if (null == apply) {
                throw new IllegalArgumentException(String.format("Key Function resolved to null for: %s", item));
            }
            if (!handled.contains(apply)) {
                map.put(apply, item);
                handled.add(apply);
            } else {
                map.remove(apply);
            }
        });
        return ImmutableMap.copyOf((Map)map);
    }

    @Nonnull
    public static <K, V, W> Map<V, W> mapWithoutDuplicates(@Nonnull Iterable<K> it, @NonNull Function<K, V> keyFn, @NonNull Function<K, W> valueFn) {
        if (keyFn == null) {
            throw new NullPointerException("keyFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        HashSet handled = Sets.newHashSet();
        LinkedHashMap map = Maps.newLinkedHashMap();
        it.forEach(item -> {
            Object keyApply = keyFn.apply(item);
            Object valueApply = valueFn.apply(item);
            if (null == keyApply) {
                throw new IllegalArgumentException(String.format("Key Function resolved to null for: %s", item));
            }
            if (!handled.contains(keyApply)) {
                map.put(keyApply, valueApply);
                handled.add(keyApply);
            } else {
                map.remove(keyApply);
            }
        });
        return ImmutableMap.copyOf((Map)map);
    }

    @NonNull
    public static <K, V, W> Multimap<K, W> map(@NonNull Iterable<V> iterable, @NonNull Function<V, K> keyFn, @NonNull Function<V, W> valueFn) {
        if (iterable == null) {
            throw new NullPointerException("iterable is marked non-null but is null");
        }
        if (keyFn == null) {
            throw new NullPointerException("keyFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        ImmutableMultimap.Builder kCollectionMap = ImmutableMultimap.builder();
        iterable.forEach(item -> {
            Object keyAsString = keyFn.apply(item);
            Object value = valueFn.apply(item);
            kCollectionMap.put(keyAsString, value);
        });
        return kCollectionMap.build();
    }

    @NonNull
    public static <K, V, W> Map<String, Iterable<W>> map(@NonNull Multimap<K, V> multimap, @NonNull Function<K, String> keyFn, @NonNull Function<V, W> valueFn) {
        if (multimap == null) {
            throw new NullPointerException("multimap is marked non-null but is null");
        }
        if (keyFn == null) {
            throw new NullPointerException("keyFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        Map kCollectionMap = multimap.asMap();
        ImmutableMap.Builder map = ImmutableMap.builder();
        kCollectionMap.forEach((key, value) -> {
            String keyAsString = (String)keyFn.apply(key);
            Iterable valuesAsString = (Iterable)value.stream().map(valueFn).collect(ImmutableList.toImmutableList());
            map.put((Object)keyAsString, (Object)valuesAsString);
        });
        return map.build();
    }

    @NonNull
    public static <V, K, W> Map<K, W> mapKeyAndValue(@NonNull Iterable<V> iterable, @NonNull Function<V, K> keyFn, @NonNull Function<V, W> valueFn) {
        if (iterable == null) {
            throw new NullPointerException("iterable is marked non-null but is null");
        }
        if (keyFn == null) {
            throw new NullPointerException("keyFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        ImmutableMap.Builder kCollectionMap = ImmutableMap.builder();
        iterable.forEach(item -> {
            Object keyAsString = keyFn.apply(item);
            Object value = valueFn.apply(item);
            kCollectionMap.put(keyAsString, value);
        });
        return kCollectionMap.build();
    }

    @Nonnull
    public static Map<Long, Integer> transformAsCountFromLong(@NonNull Multimap<Long, Long> input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        Map asMap = Multimaps.asMap(input);
        return Maps.transformValues((Map)asMap, Iterables::size);
    }

    @Nonnull
    public static Map<String, Integer> transformAsCountFromString(@NonNull Multimap<String, Long> input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        Map asMap = Multimaps.asMap(input);
        return Maps.transformValues((Map)asMap, Iterables::size);
    }
}

