/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.model.exception.request.NoBusinessUnitForUserException;
import de.qfm.erp.service.model.exception.request.NoContractConfigForContractException;
import de.qfm.erp.service.model.exception.request.NoContractForUserException;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.model.jpa.businessunit.UserBusinessUnit;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.employee.contract.EmployeeContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContractConfig;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroupRate;
import de.qfm.erp.service.model.jpa.generic.EMonth;
import de.qfm.erp.service.model.jpa.user.User;
import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EmployeeHelper {
    private static final Logger log = LogManager.getLogger(EmployeeHelper.class);
    private static final Comparator<LaborUnionWageGroupRate> LUC_COMP__LATEST_FIRST = (left, right) -> {
        LocalDate leftBegin = (LocalDate)MoreObjects.firstNonNull((Object)left.getValidBegin(), (Object)LocalDate.MIN);
        LocalDate rightBegin = (LocalDate)MoreObjects.firstNonNull((Object)right.getValidBegin(), (Object)LocalDate.MIN);
        return rightBegin.compareTo(leftBegin);
    };

    @Nonnull
    public static LaborUnionContract currentLaborUnionContractFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentLaborUnionContractFailing((User)user, (LocalDate)referenceDate, (boolean)false);
    }

    @Nonnull
    public static LaborUnionContract currentLaborUnionContractFailing(@NonNull User user, @NonNull YearMonth yearMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        return EmployeeHelper.currentLaborUnionContractFailing((User)user, (LocalDate)yearMonth.atDay(1), (boolean)true);
    }

    @Nonnull
    private static LaborUnionContract currentLaborUnionContractFailing(@NonNull User user, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        long userId = user.getId();
        int year = referenceDate.getYear();
        int month = referenceDate.getMonthValue();
        Optional laborUnionContractCandidate = EmployeeHelper.currentLaborUnionContract((User)user, (LocalDate)referenceDate, (boolean)truncateBegin);
        if (laborUnionContractCandidate.isEmpty()) {
            throw NoContractForUserException.of((String)String.format("NO Labor Union Contract for User Id: %s, Year: %s, Month: %s", userId, year, month), (Message)NoContractForUserException.message((User)user, (YearMonth)YearMonth.from(referenceDate)));
        }
        return (LaborUnionContract)laborUnionContractCandidate.get();
    }

    @Nonnull
    public static Optional<LaborUnionContract> currentLaborUnionContract(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentLaborUnionContract((User)user, (LocalDate)referenceDate, (boolean)false);
    }

    @Nonnull
    public static Optional<LaborUnionContract> currentLaborUnionContract(@NonNull User user, @NonNull YearMonth yearMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        return EmployeeHelper.currentLaborUnionContract((User)user, (LocalDate)yearMonth.atDay(1), (boolean)true);
    }

    @Nonnull
    private static Optional<LaborUnionContract> currentLaborUnionContract(@NonNull User user, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Optional employeeContractCandidate = EmployeeHelper.currentEmployeeContractNotFailing((User)user, (LocalDate)referenceDate, (boolean)truncateBegin);
        if (employeeContractCandidate.isPresent()) {
            EmployeeContract employeeContract = (EmployeeContract)employeeContractCandidate.get();
            return Optional.ofNullable(employeeContract.getLaborUnionContract());
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<EmployeeContract> currentEmployeeContractNotFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentEmployeeContractNotFailing((User)user, (LocalDate)referenceDate, (boolean)false);
    }

    @Nonnull
    public static EmployeeContract currentEmployeeContractFailing(@NonNull User user, @NonNull YearMonth yearMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        long userId = user.getId();
        int year = yearMonth.getYear();
        int month = yearMonth.getMonthValue();
        Optional employeeContract = EmployeeHelper.currentEmployeeContractNotFailing((User)user, (LocalDate)yearMonth.atDay(1), (boolean)true);
        if (employeeContract.isEmpty()) {
            throw NoContractForUserException.of((String)String.format("NO Employee Contract for User Id: %s, Year: %s, Month: %s", userId, year, month), (Message)NoContractForUserException.message((User)user, (YearMonth)yearMonth));
        }
        return (EmployeeContract)employeeContract.get();
    }

    @Nonnull
    public static Optional<EmployeeContract> currentEmployeeContractNotFailing(@NonNull User user, @NonNull YearMonth yearMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        return EmployeeHelper.currentEmployeeContractNotFailing((User)user, (LocalDate)yearMonth.atDay(1), (boolean)true);
    }

    @Nonnull
    private static Optional<EmployeeContract> currentEmployeeContractNotFailing(@NonNull User user, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Iterable employeeContracts = (Iterable)MoreObjects.firstNonNull((Object)user.getEmployeeContracts(), (Object)ImmutableList.of());
        List validContractsSorted = (List)IterableHelper.stream((Iterable)employeeContracts).filter(item -> {
            LocalDate validBegin = truncateBegin ? item.getValidBegin().withDayOfMonth(1) : item.getValidBegin();
            return EmployeeHelper.referenceDateWithinRange((LocalDate)referenceDate, (LocalDate)validBegin, (LocalDate)item.getValidEnd());
        }).collect(ImmutableList.toImmutableList());
        if (!validContractsSorted.isEmpty()) {
            return validContractsSorted.stream().findFirst();
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<BusinessUnit> currentBusinessUnitNotFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentBusinessUnit((User)user, (LocalDate)referenceDate);
    }

    @Nonnull
    public static BusinessUnit currentBusinessUnitFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        long userId = user.getId();
        int year = referenceDate.getYear();
        int month = referenceDate.getMonthValue();
        Optional businessUnitCandidate = EmployeeHelper.currentBusinessUnitNotFailing((User)user, (LocalDate)referenceDate);
        if (businessUnitCandidate.isEmpty()) {
            throw NoBusinessUnitForUserException.of((String)String.format("NO Business Unit for User Id: %s, Year: %s, Month: %s", userId, year, month), (Message)NoBusinessUnitForUserException.message((User)user, (YearMonth)YearMonth.from(referenceDate)));
        }
        return (BusinessUnit)businessUnitCandidate.get();
    }

    @Nonnull
    public static String currentCostCenterFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentCostCenterFailing((User)user, (LocalDate)referenceDate, (boolean)false);
    }

    @Nonnull
    public static String currentCostCenterFailing(@NonNull User user, @NonNull YearMonth yearMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        return EmployeeHelper.currentCostCenterFailing((User)user, (LocalDate)yearMonth.atDay(1), (boolean)true);
    }

    @Nonnull
    private static String currentCostCenterFailing(@NonNull User user, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        long userId = user.getId();
        int year = referenceDate.getYear();
        int month = referenceDate.getMonthValue();
        Optional costCenterCandidate = EmployeeHelper.currentCostCenterNotFailing((User)user, (LocalDate)referenceDate, (boolean)truncateBegin);
        if (costCenterCandidate.isEmpty()) {
            throw NoBusinessUnitForUserException.of((String)String.format("NO Cost Center for User Id: %s, Year: %s, Month: %s", userId, year, month), (Message)NoBusinessUnitForUserException.message((User)user, (YearMonth)YearMonth.from(referenceDate)));
        }
        return (String)costCenterCandidate.get();
    }

    @Nonnull
    private static Optional<BusinessUnit> currentBusinessUnit(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentUserBusinessUnitNotFailing((User)user, (LocalDate)referenceDate).map(UserBusinessUnit::getBusinessUnit);
    }

    @Nonnull
    private static Optional<UserBusinessUnit> currentUserBusinessUnitNotFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Iterable userBusinessUnits = (Iterable)MoreObjects.firstNonNull((Object)user.getUserBusinessUnits(), (Object)ImmutableSet.of());
        List validUserBusinessUnits = (List)IterableHelper.stream((Iterable)userBusinessUnits).filter(item -> EmployeeHelper.referenceDateWithinRange((LocalDate)referenceDate, (LocalDate)item.getValidBegin(), (LocalDate)item.getValidEnd())).collect(ImmutableList.toImmutableList());
        if (!validUserBusinessUnits.isEmpty()) {
            UserBusinessUnit userBusinessUnit = (UserBusinessUnit)validUserBusinessUnits.get(0);
            return Optional.of(userBusinessUnit);
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<String> currentCostCenterNotFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentCostCenterNotFailing((User)user, (LocalDate)referenceDate, (boolean)false);
    }

    @Nonnull
    public static Optional<String> currentCostCenterNotFailing(@NonNull User user, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentUserCostCenterNotFailing((User)user, (LocalDate)referenceDate, (boolean)truncateBegin).map(UserCostCenter::getCostCenter);
    }

    @Nonnull
    public static Optional<UserCostCenter> currentUserCostCenterNotFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentUserCostCenterNotFailing((User)user, (LocalDate)referenceDate, (boolean)false);
    }

    @Nonnull
    public static Optional<UserCostCenter> currentUserCostCenterNotFailing(@NonNull User user, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Iterable userCostCenters = (Iterable)MoreObjects.firstNonNull((Object)user.getUserCostCenters(), (Object)ImmutableSet.of());
        List validUserCostCenters = (List)IterableHelper.stream((Iterable)userCostCenters).filter(item -> {
            LocalDate validBegin = truncateBegin ? item.getValidBegin().withDayOfMonth(1) : item.getValidBegin();
            return EmployeeHelper.referenceDateWithinRange((LocalDate)referenceDate, (LocalDate)validBegin, (LocalDate)item.getValidEnd());
        }).collect(ImmutableList.toImmutableList());
        if (!validUserCostCenters.isEmpty()) {
            UserCostCenter userCostCenter = (UserCostCenter)validUserCostCenters.get(0);
            return Optional.of(userCostCenter);
        }
        return Optional.empty();
    }

    @Nonnull
    public static LaborUnionContractConfig currentContractConfigFailing(@NonNull YearMonth referenceMonth, @NonNull LaborUnionContract laborUnionContract) {
        if (referenceMonth == null) {
            throw new NullPointerException("referenceMonth is marked non-null but is null");
        }
        if (laborUnionContract == null) {
            throw new NullPointerException("laborUnionContract is marked non-null but is null");
        }
        int year = referenceMonth.getYear();
        int month = referenceMonth.getMonthValue();
        long laborUnionContractId = laborUnionContract.getId();
        String laborUnionContractName = laborUnionContract.getName();
        Optional laborUnionContractConfigCandidate = EmployeeHelper.currentContractConfigNotFailing((YearMonth)referenceMonth, (LaborUnionContract)laborUnionContract);
        if (laborUnionContractConfigCandidate.isEmpty()) {
            throw NoContractConfigForContractException.of((String)String.format("No Contract Config for Month: %s, Year: %s, Contract: %s (Id: %s)", month, year, laborUnionContractName, laborUnionContractId), (Message)NoContractConfigForContractException.message((LaborUnionContract)laborUnionContract, (YearMonth)referenceMonth));
        }
        return (LaborUnionContractConfig)laborUnionContractConfigCandidate.get();
    }

    @Nonnull
    public static Optional<LaborUnionContractConfig> currentContractConfigNotFailing(@NonNull YearMonth referenceMonth, @NonNull LaborUnionContract laborUnionContract) {
        if (referenceMonth == null) {
            throw new NullPointerException("referenceMonth is marked non-null but is null");
        }
        if (laborUnionContract == null) {
            throw new NullPointerException("laborUnionContract is marked non-null but is null");
        }
        EMonth month = EMonth.from((Month)referenceMonth.getMonth());
        LocalDate firstOfMonth = referenceMonth.atDay(1);
        Set laborUnionContractConfigs = laborUnionContract.getConfigs();
        List validContractsWithMonth = (List)IterableHelper.stream((Iterable)laborUnionContractConfigs).filter(item -> month == item.getMonth()).collect(ImmutableList.toImmutableList());
        List validContractsWithDateAndMonth = (List)IterableHelper.stream((Iterable)validContractsWithMonth).filter(item -> EmployeeHelper.referenceDateWithinRange((LocalDate)firstOfMonth, (LocalDate)item.getValidBegin(), (LocalDate)item.getValidEnd())).collect(ImmutableList.toImmutableList());
        List validContractsConfigsSorted = (List)IterableHelper.stream((Iterable)validContractsWithDateAndMonth).sorted(Comparator.comparing(LaborUnionContractConfig::getValidBegin)).collect(ImmutableList.toImmutableList());
        if (!validContractsConfigsSorted.isEmpty()) {
            return validContractsConfigsSorted.stream().findFirst();
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<String> currentContractName(@NonNull User user, @NonNull YearMonth yearMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        return EmployeeHelper.currentContractName((User)user, (LocalDate)yearMonth.atDay(1), (boolean)true);
    }

    public static Optional<String> currentContractName(@NonNull User user, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        EmployeeContract employeeContract;
        LaborUnionContract contract;
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Optional employeeContractCandidate = EmployeeHelper.currentEmployeeContractNotFailing((User)user, (LocalDate)referenceDate, (boolean)truncateBegin);
        if (employeeContractCandidate.isPresent() && null != (contract = (employeeContract = (EmployeeContract)employeeContractCandidate.get()).getLaborUnionContract())) {
            return Optional.of(StringUtils.trimToEmpty((String)contract.getName()));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<LaborUnionWageGroup> currentWageGroup(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentWageGroup((User)user, (LocalDate)referenceDate, (boolean)false);
    }

    @Nonnull
    public static Optional<LaborUnionWageGroup> currentWageGroup(@NonNull User user, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Optional employeeContractCandidate = EmployeeHelper.currentEmployeeContractNotFailing((User)user, (LocalDate)referenceDate, (boolean)truncateBegin);
        if (employeeContractCandidate.isPresent()) {
            EmployeeContract employeeContract = (EmployeeContract)employeeContractCandidate.get();
            LaborUnionWageGroup wageGroup = employeeContract.getLaborUnionWageGroup();
            return Optional.ofNullable(wageGroup);
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<LaborUnionWageGroupRate> currentWageGroupRateNotFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentWageGroupRateNotFailing((User)user, (LocalDate)referenceDate, (boolean)false);
    }

    @Nonnull
    public static Optional<LaborUnionWageGroupRate> currentWageGroupRateNotFailing(@NonNull User user, @NonNull YearMonth yearMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        return EmployeeHelper.currentWageGroupRateNotFailing((User)user, (LocalDate)yearMonth.atDay(1), (boolean)true);
    }

    @Nonnull
    private static Optional<LaborUnionWageGroupRate> currentWageGroupRateNotFailing(@NonNull User user, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Optional laborUnionWageGroupCandidate = EmployeeHelper.currentWageGroup((User)user, (LocalDate)referenceDate, (boolean)truncateBegin);
        if (laborUnionWageGroupCandidate.isPresent()) {
            LaborUnionWageGroup laborUnionWageGroup = (LaborUnionWageGroup)laborUnionWageGroupCandidate.get();
            Set wageGroupRates = (Set)MoreObjects.firstNonNull((Object)laborUnionWageGroup.getWageGroupRates(), (Object)ImmutableSet.of());
            return EmployeeHelper.currentWageGroupRateNotFailing((Iterable)wageGroupRates, (LocalDate)referenceDate);
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<LaborUnionWageGroupRate> currentWageGroupRateNotFailing(@NonNull Iterable<LaborUnionWageGroupRate> wageGroupRates, @NonNull LocalDate referenceDate) {
        if (wageGroupRates == null) {
            throw new NullPointerException("wageGroupRates is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return EmployeeHelper.currentWageGroupRateNotFailing(wageGroupRates, (LocalDate)referenceDate, (boolean)false);
    }

    @Nonnull
    public static Optional<LaborUnionWageGroupRate> currentWageGroupRateNotFailing(@NonNull Iterable<LaborUnionWageGroupRate> wageGroupRates, @NonNull LocalDate referenceDate, boolean truncateBegin) {
        if (wageGroupRates == null) {
            throw new NullPointerException("wageGroupRates is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        List validSorted = (List)IterableHelper.stream(wageGroupRates).filter(item -> {
            LocalDate validBegin = truncateBegin ? item.getValidBegin().withDayOfMonth(1) : item.getValidBegin();
            return EmployeeHelper.referenceDateWithinRange((LocalDate)referenceDate, (LocalDate)validBegin, (LocalDate)item.getValidEnd());
        }).collect(ImmutableList.toImmutableList());
        if (!validSorted.isEmpty()) {
            return validSorted.stream().findFirst();
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<LaborUnionWageGroupRate> lastWageGroupRateNotFailing(@NonNull LaborUnionWageGroup laborUnionWageGroup, @NonNull Range<LocalDate> referenceDateRange) {
        if (laborUnionWageGroup == null) {
            throw new NullPointerException("laborUnionWageGroup is marked non-null but is null");
        }
        if (referenceDateRange == null) {
            throw new NullPointerException("referenceDateRange is marked non-null but is null");
        }
        Set wageGroupRates = (Set)MoreObjects.firstNonNull((Object)laborUnionWageGroup.getWageGroupRates(), (Object)ImmutableSet.of());
        return EmployeeHelper.lastWageGroupRateNotFailing((Iterable)wageGroupRates, referenceDateRange);
    }

    @Nonnull
    public static Optional<LaborUnionWageGroupRate> lastWageGroupRateNotFailing(@NonNull Iterable<LaborUnionWageGroupRate> wageGroupRates, @NonNull Range<LocalDate> referenceDateRange) {
        if (wageGroupRates == null) {
            throw new NullPointerException("wageGroupRates is marked non-null but is null");
        }
        if (referenceDateRange == null) {
            throw new NullPointerException("referenceDateRange is marked non-null but is null");
        }
        List matchingRates = (List)IterableHelper.stream(wageGroupRates).filter(item -> EmployeeHelper.referenceDateWithinRange((Range)referenceDateRange, (LocalDate)item.getValidBegin(), (LocalDate)item.getValidEnd())).sorted(LUC_COMP__LATEST_FIRST).collect(ImmutableList.toImmutableList());
        if (!matchingRates.isEmpty()) {
            return matchingRates.stream().findFirst();
        }
        return Optional.empty();
    }

    @Nonnull
    public static Predicate<UserCostCenter> userCostCenterAt(@NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return input -> {
            if (null == input) {
                return false;
            }
            return EmployeeHelper.referenceDateWithinRange((LocalDate)referenceDate, (LocalDate)input.getValidBegin(), (LocalDate)input.getValidEnd());
        };
    }

    private static boolean referenceDateWithinRange(@NonNull LocalDate referenceDate, @Nullable LocalDate begin, @Nullable LocalDate end) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        LocalDate safeBegin = (LocalDate)MoreObjects.firstNonNull((Object)begin, (Object)LocalDate.MIN);
        LocalDate safeEnd = (LocalDate)MoreObjects.firstNonNull((Object)end, (Object)LocalDate.MAX);
        return Range.closed((Comparable)safeBegin, (Comparable)safeEnd).contains((Comparable)referenceDate);
    }

    private static boolean referenceDateWithinRange(@NonNull Range<LocalDate> referenceDateRange, @Nullable LocalDate begin, @Nullable LocalDate end) {
        if (referenceDateRange == null) {
            throw new NullPointerException("referenceDateRange is marked non-null but is null");
        }
        LocalDate safeBegin = (LocalDate)MoreObjects.firstNonNull((Object)begin, (Object)LocalDate.MIN);
        LocalDate safeEnd = (LocalDate)MoreObjects.firstNonNull((Object)end, (Object)LocalDate.MAX);
        return Range.closed((Comparable)safeBegin, (Comparable)safeEnd).isConnected(referenceDateRange);
    }
}

