/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.InvoiceHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.model.internal.quotation.ER2InvoiceInputBucket;
import de.qfm.erp.service.model.internal.quotation.ER2StageInputBucket;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ER2Helper {
    private static final Joiner COL_JOINER = Joiner.on((String)",").useForNull("");
    private static final Joiner ROW_JOINER = Joiner.on((String)"\n").useForNull("");
    private static final Map<EInvoiceType, String> INVOICE_DESCRIPTOR = ImmutableMap.builder().put((Object)EInvoiceType.CREDIT_VOUCHER, (Object)"CV").put((Object)EInvoiceType.INTERNAL_INVOICE, (Object)"II").put((Object)EInvoiceType.CUSTOMER_VOUCHER, (Object)"GU").put((Object)EInvoiceType.INTERNAL_VOUCHER, (Object)"IB").put((Object)EInvoiceType.PARTIAL_INVOICE, (Object)"TR").put((Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)"TSR").put((Object)EInvoiceType.FINAL_INVOICE, (Object)"SR").put((Object)EInvoiceType.PARTIAL_CUMULATIVE_INVOICE, (Object)"X").put((Object)EInvoiceType.FINAL_CUMULATIVE_INVOICE, (Object)"X").put((Object)EInvoiceType.CUMULATIVE_INVOICE, (Object)"X").put((Object)EInvoiceType.INVOICE, (Object)"R").build();

    @Nonnull
    public static String costUnit(@NonNull ER2StageInputBucket er2StageInputBucket) {
        if (er2StageInputBucket == null) {
            throw new NullPointerException("er2StageInputBucket is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = er2StageInputBucket.getStageOrEntityNumberPrefix();
        Quotation stage = er2StageInputBucket.getStage();
        String costUnit = StageHelper.costUnit((Quotation)stage);
        EStageOrigin origin = stage.getOrigin();
        if (origin == EStageOrigin.QUANTE_V1) {
            return StringUtils.removeStart((String)StringUtils.remove((String)costUnit, (String)"/"), (String)stageOrEntityNumberPrefix);
        }
        return StringUtils.removeStart((String)costUnit, (String)stageOrEntityNumberPrefix);
    }

    public static byte[] asBytes(@NonNull Iterable<Iterable<String>> rows) {
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        Iterable rowsAsString = (Iterable)Streams.stream(rows).map(arg_0 -> ((Joiner)COL_JOINER).join(arg_0)).collect(ImmutableList.toImmutableList());
        String allRowsAsString = ROW_JOINER.join(rowsAsString);
        return allRowsAsString.getBytes(StandardCharsets.ISO_8859_1);
    }

    @Nonnull
    public static String value(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        Integer internalPartialNumber = invoice.getInternalPartialNumber();
        Integer internalPartialFinalNumber = invoice.getInternalPartialFinalNumber();
        String invoiceDescriptorPart = (String)INVOICE_DESCRIPTOR.get(invoiceType);
        Object invoiceDescriptor = invoiceType == EInvoiceType.PARTIAL_INVOICE ? internalPartialNumber + ". " + invoiceDescriptorPart : (invoiceType == EInvoiceType.PARTIAL_FINAL_INVOICE ? internalPartialFinalNumber + ". " + invoiceDescriptorPart : invoiceDescriptorPart);
        Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        String measurementNumbers = Streams.stream((Iterable)measurements).map(Measurement::getMeasurementNumber).filter(Objects::nonNull).distinct().collect(Collectors.joining(","));
        return String.format("%s - %s", invoiceDescriptor, measurementNumbers);
    }

    @Nonnull
    public static String measurementNumbers(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        ImmutableSet measurementNumbers = (ImmutableSet)Streams.stream((Iterable)measurements).map(Measurement::getMeasurementNumber).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return Joiner.on((String)"; ").join((Iterable)measurementNumbers);
    }
}

