/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class DateRangeHelper {
    @Nonnull
    public static Iterable<Range<LocalDate>> overlappingDates(@NonNull Iterable<Range<LocalDate>> dateRanges) {
        if (dateRanges == null) {
            throw new NullPointerException("dateRanges is marked non-null but is null");
        }
        ImmutableList.Builder overlappingBuilder = ImmutableList.builder();
        TreeRangeSet ranges = TreeRangeSet.create();
        for (Range<LocalDate> dateRange : dateRanges) {
            if (ranges.intersects(dateRange)) {
                overlappingBuilder.add(dateRange);
            }
            ranges.add(dateRange);
        }
        return overlappingBuilder.build();
    }

    @Nonnull
    public static Range<LocalDate> dateRange(@Nullable LocalDate dateRangeFrom, @Nullable LocalDate dateRangeTo) {
        if (null != dateRangeFrom && null != dateRangeTo) {
            return Range.closed((Comparable)dateRangeFrom, (Comparable)dateRangeTo);
        }
        if (null != dateRangeFrom) {
            return Range.atLeast((Comparable)dateRangeFrom);
        }
        if (null != dateRangeTo) {
            return Range.atMost((Comparable)dateRangeTo);
        }
        return Range.all();
    }

    @Nonnull
    public static Range<LocalDateTime> dateTimeRange(@Nullable LocalDateTime dateTimeRangeFrom, @Nullable LocalDateTime dateTimeRangeTo) {
        if (null != dateTimeRangeFrom && null != dateTimeRangeTo) {
            return Range.closed((Comparable)dateTimeRangeFrom, (Comparable)dateTimeRangeTo);
        }
        if (null != dateTimeRangeFrom) {
            return Range.atLeast((Comparable)dateTimeRangeFrom);
        }
        if (null != dateTimeRangeTo) {
            return Range.atMost((Comparable)dateTimeRangeTo);
        }
        return Range.all();
    }
}

